/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;

/**
 *
 * @author Yu-Tang
 */
public class MoeUIDelegator {

    private BufferedImage image = null;
    private BufferedImage tiledImage = null;
    private Color bgColor = null;
    private JComponent component = null;
    private final float DEFAULT_ALPHA = MoeUI.OPACITY_HALF;
    private float alpha = DEFAULT_ALPHA;
    private AlphaComposite alphaComposite = getAlphaComposite(alpha);
    private int marginTop = 0;

    public void setOpacity(float opacity) {
        this.alpha = opacity;
        this.alphaComposite = opacity >= MoeUI.OPACITY_OPAQUE ?
                null : getAlphaComposite(opacity);
    }

    public void setBackgroundImage(BufferedImage image) {
        this.image = image;

        if (component == null) {
            this.tiledImage = image;
        } else {
            this.tiledImage = createTiledImage(image,
                    component.getWidth(), component.getHeight());
        }
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
        if (component != null) {
            component.setBackground(color);
        }
    }

    public BufferedImage getBackgroundImage() {
        return image;
    }

    public Color getBackgroundColor() {
        return bgColor;
    }

    public void setComponent(JComponent c) {
        // change transparent component to opaque
        if (!c.isOpaque()) {
            c.setOpaque(true);
        }
        if (bgColor != null) {
            c.setBackground(bgColor);
        }
        this.component = c;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public void paintBackground(Graphics g) {
        if (image != null) {
            Graphics2D g2 = (Graphics2D) g.create();
            if (alphaComposite != null) {
                g2.setComposite(alphaComposite);
            }
            if (bgColor != null) {
                g2.setBackground(bgColor);
            }
            // 当初 TexturePaint を用意して、
            //     g2.setPaint(paint);
            //     g2.fillRect(0, 0, getWidth(), getHeight());
            // などとしていたが、メニューバーなどが不透過に設定された場合に
            // 背景の描画開始位置を下げる必要があり、テクスチャによるタイリング
            // では対応できなかった（描画開始位置を下げてもテクスチャの位置が
            // 変わらないので、テクスチャの途中から描画が始まる感じ）。
            // そこで、自前でタイリング画像を作って保持し、その一枚絵を貼る路線
            // に変更する。
            int width = component.getWidth();
            int height = component.getHeight();
            if (width > tiledImage.getWidth() || height > tiledImage.getHeight()) {
                tiledImage = createTiledImage(image, width, height);
            }
            g2.drawImage(tiledImage, 0, marginTop, component);
            g2.dispose();
        }
    }

    private AlphaComposite getAlphaComposite(float alpha) {
        int type = AlphaComposite.SRC_OVER;
        return AlphaComposite.getInstance(type, alpha);
    }

    private BufferedImage createTiledImage(BufferedImage image, int width, int height) {
        WritableRaster r1 = image.getRaster();
        WritableRaster r2 = r1.createCompatibleWritableRaster(width, height);
        int w = r1.getWidth();
        int h = r1.getHeight();
        for (int x = 0; x < width; x += w) {
            for (int y = 0; y < height; y += h) {
                r2.setRect(x, y, r1);
            }
        }
        BufferedImage ret = new BufferedImage(width, height, image.getType());
        ret.setData(r2);
        return ret;
    }
}
