/*
 * CQ-FRK-FM3 w/ WK-FM3 MMC drievr
 */

#include <common.h>
#include <asm-generic/gpio.h>
#include <spi.h>

int  spi_cs_is_valid(unsigned int bus, unsigned int cs)
{
	return (bus == 0 && cs == 1);
}

void spi_cs_activate(struct spi_slave *slave)
{
	gpio_set_value(0x0300, 0);
}

void spi_cs_deactivate(struct spi_slave *slave)
{
	gpio_set_value(0x0300, 1);
}

int board_mmc_init(bd_t *bis)
{
	if (gpio_request(0x0300, "mmc-cs") == 0) {
		gpio_set_value(0x0300, 1);
		gpio_direction_output(0x0300, 0);
		return 0;
	} else
		return -1;
}
