/*
 * Copyright (c) 2004-2008 Texas Instruments
 *
 * (C) Copyright 2002
 * Gary Jennejohn, DENX Software Engineering, <garyj@denx.de>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

OUTPUT_FORMAT("elf32-littlearm", "elf32-littlearm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)
MEMORY
{
	rom : ORIGIN = 0x00000000, LENGTH = 1M
	iram : ORIGIN = 0x1fff0000, LENGTH = 128K
	ram : ORIGIN = 0x62300000, LENGTH = 1M
}

SECTIONS
{
	. = 0x00000000;

	. = ALIGN(4);
	_stext = .;
	.text :
	{
		CPUDIR/start.o (.text*)
		*(.text*)
	} > rom

	. = ALIGN(4);
	.rodata :
	{
		*(SORT_BY_ALIGNMENT(SORT_BY_NAME(.rodata*)))
	} > rom

	. = ALIGN(4);
	.u_boot_list : {
		KEEP(*(SORT(.u_boot_list*)));
	} > rom
	_etext = .;
	_sdata_lma = .;
	.text2 :
	{
		_sdata = .;
		*(.ram_text);
	} > iram AT>rom
	.data :
	{
		*(SORT_BY_ALIGNMENT(SORT_BY_NAME(.data*)))
		_edata = .;
	} > iram AT>rom

	.bss_start : {
		KEEP(*(.__bss_start));
		__bss_base = .;
	} > ram

	.bss : {
		*(.bss*)
		 . = ALIGN(4);
		 __bss_limit = .;
	} > ram

	.bss_end : {
		KEEP(*(.__bss_end));
	} > ram
	_end = .;
}
