/*
 * Startup Code for Spansion FM3
 *
 * Copyright (c) 2014 Yoshinori Sato <ysato@users.sourceforge.jp>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <asm/io.h>

#define CR_SCM_CTL   0x40010000
#define CR_SCM_STR   0x40010004
#define CR_BSC_PSR   0x40010010
#define CR_APBC0_PSR 0x40010014
#define CR_APBC1_PSR 0x40010018
#define CR_APBC2_PSR 0x4001001C
#define CR_SWC_PSR   0x40010020
#define CR_TTC_PSR   0x40010028
#define CR_CSW_TMR   0x40010030
#define CR_PSW_TMR   0x40010034
#define CR_PLL_CTL1  0x40010038
#define CR_PLL_CTL2  0x4001003C
#define CR_INT_ENR   0x40010060

#define WDT_CTL     0x40011008
#define WDT_LCK     0x40011C00

void s_init(void)
{
	unsigned int scm_ctl;
	writel(0x1acce551, WDT_LCK);
	writel(0xe5331aae, WDT_LCK);
	writeb(0x00, WDT_CTL);

	writeb(0x00, CR_BSC_PSR);
	writeb(0x02, CR_APBC0_PSR);
	writeb(0x82, CR_APBC1_PSR);
	writeb(0x82, CR_APBC2_PSR);
	writeb(0x83, CR_SWC_PSR);
	writeb(0x00, CR_TTC_PSR);

	writeb(0x5c, CR_CSW_TMR);
	writeb(readb(CR_SCM_CTL) | 0x02, CR_SCM_CTL);
	while (!(readb(CR_SCM_STR) & 0x02));
	writeb(0x00, CR_PSW_TMR);
	writeb(0x01, CR_PLL_CTL1);
	writeb(35, CR_PLL_CTL2);
	writeb(readb(CR_SCM_CTL) | 0x10, CR_SCM_CTL);
	while (!(readb(CR_SCM_STR) & 0x10));
	writeb(readb(CR_SCM_CTL) | 0x40, CR_SCM_CTL);
	writeb(readb(CR_SCM_CTL) | (0x52 & 0xe0), CR_SCM_CTL);
	do {
		scm_ctl = readl(CR_SCM_CTL) & 0xe0;
	} while((readl(CR_SCM_STR) & 0xe0) != scm_ctl);
}
