﻿#define DISABLE_XAML_GENERATED_BREAK_ON_UNHANDLED_EXCEPTION

using AutoMapper;
using CleanAuLait;
using CleanAuLait.Core.Log;
using Microsoft.UI;
using Microsoft.UI.Windowing;
using Microsoft.UI.Xaml;
using Microsoft.UI.Xaml.Controls;
using NLog;
using Prism.Ioc;
using Prism.Modularity;
using Prism.Unity;
using System;
using System.Reflection;
using System.Threading.Tasks;
using TestNarou3.Adaptor;
using TestNarou3.Adaptor.Boundary.Controller;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Core.Mapper;
using TestNarou3.Domain;
using TestNarou3.Infra;
using TestNarou3.OuterEdge;
using TestNarou3.OuterEdge.UI.View;
using TestNarou3.UseCase;
using TestNarou3.UseCase.Request;
using Windows.ApplicationModel.Core;

// To learn more about WinUI, the WinUI project structure,
// and more about our project templates, see: http://aka.ms/winui-project-info.

namespace TestNarou3;
/// <summary>
/// Interaction logic for App.xaml
/// </summary>
public partial class App : PrismApplication
{
    private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

    public App()
    {
        //DispatcherUnhandledException += OnDispatcherException;
        TaskScheduler.UnobservedTaskException += OnTaskException;
        AppDomain.CurrentDomain.UnhandledException += OnCurrentDomainUnhandledException;
        CoreApplication.UnhandledErrorDetected += OnCoreAppUnhandledException;
        UnhandledException += OnAppUnhandledException;

        LogManager.Setup().SetupExtensions(s => s.RegisterLayoutRenderer<SimpleLoggerLayoutRenderer>("simplelogger"));
    }

#if false
    private void OnDispatcherException(object sender, DispatcherUnhandledExceptionEventArgs e)
    {
        ShowException(e.Exception, "Unhandled DispatcherException raised.");
        Environment.Exit(1);
    }
#endif

    private void OnTaskException(object sender, UnobservedTaskExceptionEventArgs e)
    {
        ShowException(e.Exception, "Unobserved TaskException raised.");
        Environment.Exit(1);
    }

    private void OnCurrentDomainUnhandledException(object sender, System.UnhandledExceptionEventArgs e)
    {
        ShowException(e.ExceptionObject as Exception, "CurrentDomain Unhandled Exception raised.");
        Environment.Exit(1);
    }

    private void OnCoreAppUnhandledException(object sender, UnhandledErrorDetectedEventArgs e)
    {
        try
        {
            e.UnhandledError.Propagate();
        }
        catch (Exception ex)
        {
            ShowException(ex, "App Unhandled Exception raised.");
        }
        Environment.Exit(1);
    }

    private void OnAppUnhandledException(object sender, Microsoft.UI.Xaml.UnhandledExceptionEventArgs e)
    {
        ShowException(e.Exception, "App Unhandled Exception raised.");
        Environment.Exit(1);
    }

    private static void ShowException(Exception e, string detail = null)
    {
        logger.Error(e);
        string msg = string.Empty;
        msg += detail + "\n";
        msg += e.ToString();

        string caption = Assembly.GetExecutingAssembly().GetName().Name;
        string subCaption = "Critical Error";
#if true
        ContentDialog contentDialog = new ContentDialog
        {
            Title = string.Format("{0} - {1}", caption, subCaption),
            Content = msg,
            CloseButtonText = "OK"
        };

        _ = contentDialog.ShowAsync().GetResults();
#else
        logger.Error("{0} - {1}: {2}", caption, subCaption, msg);
#endif
    }

    protected override void InitializeModules()
    {
        var manager = Container.Resolve<IModuleManager>();
        manager.LoadModuleCompleted += OnLoadModuleCompleted;

        base.InitializeModules();
    }


    private void OnLoadModuleCompleted(object sender, LoadModuleCompletedEventArgs e)
    {
        OnLoadModuleCompleted(e.ModuleInfo, e.Error, e.IsErrorHandled);
    }

    protected virtual void OnLoadModuleCompleted(IModuleInfo moduleInfo, Exception error, bool isHandled)
    {
        if (error != null)
        {
            if (error is ContainerResolutionException cre)
            {
                var errors = cre.GetErrors();
                foreach ((var type, var ex) in errors)
                {
                    ShowException(ex, $"Error with: {type.FullName}");
                }
            }
            else
            {
                ShowException(error);
            }
        }
    }

    protected override void ConfigureViewModelLocator()
    {
        base.ConfigureViewModelLocator();
#if false
            ViewModelLocationProvider.SetDefaultViewTypeToViewModelTypeResolver(viewType =>
            {
                TypeInfo adaptorTypeInfo = typeof(AdaptorModule).GetTypeInfo();

                string viewModelFullName = $"{adaptorTypeInfo.Namespace}.Gateway.ViewModel.{viewType.Name}Model";
                string typeName = $"{viewModelFullName}, {adaptorTypeInfo.Assembly.FullName}";

                System.Diagnostics.Debug.WriteLine("ConfigureViewModelLocator: " + typeName);

                return Type.GetType(typeName);
            });
#endif
        logger.Trace("ConfigureVWiewModelLocator end");
    }

    protected override void ConfigureModuleCatalog(IModuleCatalog moduleCatalog)
    {
        moduleCatalog.AddModule<CleanAuLaitPrismWinUI3Module>();

        moduleCatalog.AddModule<InfraModule>(
                dependsOn: new string[] { nameof(CleanAuLaitPrismWinUI3Module) });

        moduleCatalog.AddModule<DomainModule>(
                dependsOn: new string[] { nameof(InfraModule) });

        moduleCatalog.AddModule<UseCaseModule>(
                dependsOn: new string[] { nameof(DomainModule) });

        moduleCatalog.AddModule<AdaptorModule>(
                dependsOn: new string[] { nameof(UseCaseModule) });

        moduleCatalog.AddModule<OuterEdgeModule>(
                dependsOn: new string[] { nameof(AdaptorModule) });

        logger.Trace("ConfigureModuleCatalog end");
    }

    protected override void RegisterTypes(IContainerRegistry containerRegistry)
    {
        //
        // Mapper
        //

        IMapper mapper = new MapperFactory().Instance;
        containerRegistry.RegisterInstance(mapper);

#if false
            //
            // Logger
            //

            containerRegistry.RegisterSingleton<IAsyncOnLogTarget>(() => new AsyncOnLogTarget("TextBoxLogger", Settings.Default.MinLogLevel)
            {
                Layout = "${date:format=yyyy/MM/dd HH\\:mm\\:ss} [${uppercase:${level:padding=-5}}] ${message}"
            });

            logger.Trace("RegisterTypes end");
#endif
    }

    protected override UIElement CreateShell()
    {
        // Ensure Required Modules loaded.
        var moduleManager = Container.Resolve<IModuleManager>();
        moduleManager.LoadModule<OuterEdgeModule>();

        UIElement shell = Container.Resolve<MainWindowView>();

        logger.Trace("CreateShell end");

        return shell;
    }

    protected override void OnInitialized()
    {
        base.OnInitialized();
#if false
            // Restore App Settrings

            IAppWindowController controller = Container.Resolve<IAppWindowController>();
            controller.Execute(new RestoreAppSettingRequest());
#endif
        logger.Trace("OnInitialized end");
    }

    protected override void OnLaunched(LaunchActivatedEventArgs e)
    {
        base.OnLaunched(e);

        // Show Application Version

        AssemblyName asm = Assembly.GetExecutingAssembly().GetName();
        Version ver = asm.Version;

        logger.Info("{0} v{1}.{2}.{3}.{4}",
             asm.Name, ver.Major, ver.Minor, ver.Build, ver.Revision);

        AppWindow appWindow = GetCurrentAppWindow();
        appWindow.Title = "TestNarou3";
        appWindow.Closing += OnClosing;

        PrepareInitialView();

        logger.Trace("OnStartup end");
    }

    private void PrepareInitialView()
    {
        var wc = Container.Resolve<IAppWindowController>(); ;

        // Load Application Settings
        _ = wc.Execute(new AppConfigLoadRequest());

        // Navigate Login Form View
        wc.NavigateLoginFormView();
    }

    private AppWindow GetCurrentAppWindow()
    {
        IntPtr hwnd = WinRT.Interop.WindowNative.GetWindowHandle(MainWindow);
        WindowId winId = Win32Interop.GetWindowIdFromWindow(hwnd);

        return AppWindow.GetFromWindowId(winId);
    }

    private void OnClosing(AppWindow sender, AppWindowClosingEventArgs args)
    {
        logger.Trace("OnClosing called.");

        var vm = Container.Resolve<IMainWindowViewModel>();
        vm.OnClosing();

        if (Container.GetContainer() is IDisposable disposable)
        {
            disposable.Dispose();
        }

        LogManager.Shutdown();
    }

#if false
    protected override void OnExit(ExitEventArgs e)
    {
        logger.Trace("OnExit begin");

        // Shutdown Log Manager

        IAsyncOnLogTarget onLogTarget = Container.Resolve<IAsyncOnLogTarget>();
        onLogTarget.Close();

        logger.Trace("OnExit end");

        LogManager.Shutdown();

        base.OnExit(e);
    }
#endif
}
