﻿using TestNarou3.Domain.Boundary.Repository;
using TestNarou3.Domain.Boundary.Service;
using TestNarou3.Domain.Model.Config;

namespace TestNarou3.Domain.Service
{
    internal class AppConfigService : IAppConfigService
    {
        private AppConfig AppConfig => this.appConfig ??= this.repo.Load();

        private AppConfig appConfig;
        private readonly IAppConfigRepository repo;

        public AppConfigService(IAppConfigRepository repo)
        {
            this.repo = repo;
        }

        public AppConfig Load()
        {
            return this.AppConfig;
        }

        public void Save()
        {
            this.repo.Save(this.AppConfig);
        }

        public void Update(NarouLoginSettings settings)
        {
            this.appConfig = this.AppConfig with { NarouLoginSettings = settings };
        }
    }
}
