﻿using NLog;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;
using System;
using System.Reactive.Disposables;

namespace TestNarou3.Domain.Model.Entity.Child
{
    public partial record class BookmarkCategoryRow(
        int Index,
        ReactivePropertySlim<string> Name,
        ReactivePropertySlim<int> Count
    ) : IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        private readonly CompositeDisposable disposables = new();
        private bool disposedValue;

        public BookmarkCategoryRow(int index): this(
            Index:      index,
            Name:       new(),
            Count:      new()
        )
        {
            this.Name.AddTo(this.disposables);
            this.Count.AddTo(this.disposables);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    this.disposables.Dispose();
                    logger.Trace("BookmarkCategoryRow[{0}] disposed.", Index);
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            // このコードを変更しないでください。クリーンアップ コードを 'Dispose(bool disposing)' メソッドに記述します
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }
    }
}
