﻿using NLog;
using ObservableCollections;
using System;
using System.Collections.Generic;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Domain.Model.Entity
{
    public record class BookmarkDetailList(
        ObservableList<BookmarkDetailListRow> Rows
    ) : IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        private bool disposedValue;

        public BookmarkDetailList() : this(
            Rows: new()
        )
        {
        }

        public void Refresh(IEnumerable<BookmarkDetailListRow> rows)
        {
            this.Rows.Clear();
            this.Rows.AddRange(rows);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    foreach (var row in Rows)
                    {
                        row.Dispose();
                    }

                    logger.Trace("BookmarkDetailList disposed.");
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }
    }
}
