﻿using AutoMapper;
using Reactive.Bindings;
using System;
using System.Linq;
using System.Reactive.Linq;

namespace TestNarou3.Adaptor.Translator.Converter
{
    internal class MinToHourConverter
            : IValueConverter<IObservable<int>, ReadOnlyReactiveProperty<int>>
    {
        public ReadOnlyReactiveProperty<int> Convert(
                IObservable<int> sourceMember, ResolutionContext context)
        {
            return sourceMember
                    .Select(v => (int)Math.Round((double)v / 60, 0, MidpointRounding.AwayFromZero))
                    .ToReadOnlyReactiveProperty();
        }
    }
}
