﻿using AutoMapper;
using Reactive.Bindings;
using System.Reactive.Linq;
using TestNarou3.Adaptor.Gateway.ViewModel.Child;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor.Translator.Converter
{
    internal class MinPerAllNoResolver
            : IValueResolver<BookmarkDetailListRow, BookmarkDetailListRowViewModel, ReadOnlyReactiveProperty<int>>
    {
        public ReadOnlyReactiveProperty<int> Resolve(
                BookmarkDetailListRow source, BookmarkDetailListRowViewModel destination,
                ReadOnlyReactiveProperty<int> destMember, ResolutionContext context)
        {
            return source.Time.CombineLatest(source.GeneralAllNo, (time, allNo) => Convert(time, allNo)).ToReadOnlyReactiveProperty();
        }

        private static int Convert(int time, int allNo)
        {
            return (int)Math.Round((double)time / allNo, 0, MidpointRounding.AwayFromZero);
        }
    }
}
