﻿using AutoMapper;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel.Child;
using TestNarou3.Adaptor.Gateway.ViewModel.Child;
using TestNarou3.Adaptor.Translator.Converter;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor.Translator
{
    internal class BookmarkCategoryRowViewModelTranslator
            : IBookmarkCategoryRowViewModelTranslator
    {
        private readonly IMapper mapper;

        public BookmarkCategoryRowViewModelTranslator(IMapper mapper)
        {
            this.mapper = mapper;
        }

        public IBookmarkCategoryRowViewModel Translate(BookmarkCategoryRow row, IBookmarkCategoryViewModel vm)
        {
            IBookmarkCategoryRowViewModel rowVm = row != null
                    ? mapper.Map(row, new BookmarkCategoryRowViewModel(row, vm))
                    : null;

            return rowVm;
        }

        internal static void ConfigureMapper(
                IMappingExpression<BookmarkCategoryRow, BookmarkCategoryRowViewModel> mappingExpression)
        {
            mappingExpression
                    .ForMember(d => d.Index,
                            opts => opts.MapFrom(s => s.Index))
                    .ForMember(d => d.ItemImage,
                            opts => opts.Ignore())
                    .ForMember(d => d.Name,
                            opts => opts.MapFrom(s => s.Name))
                    .ForMember(d => d.Count,
                            opts => opts.MapFrom(s => s.Count))
                    .ForMember(d => d.Parent,
                            opts => opts.Ignore())
                    .ForMember(d => d.Source,
                            opts => opts.Ignore())

                    .DisableCtorValidation()
                    .AfterMap<BookmarkCategoryRowViewModel.AfterMap>();
        }
    }
}
