﻿using AutoMapper;
using TestNarou3.Adaptor.Gateway.ViewModel.Child;
using TestNarou3.Adaptor.Translator;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor
{
    public class AdaptorMappingProfile : Profile
    {
        public AdaptorMappingProfile()
        {
            ShouldMapField = x => false;
            ShouldMapMethod = x => false;
            ShouldMapProperty = x => true;
            ShouldUseConstructor = x => false;

            BookmarkCategoryRowViewModelTranslator
                    .ConfigureMapper(CreateMap<BookmarkCategoryRow, BookmarkCategoryRowViewModel>());

            BookmarkDetailListRowViewModelTranslator
                    .ConfigureMapper(CreateMap<BookmarkDetailListRow, BookmarkDetailListRowViewModel>());
        }
    }
}
