//******************************************************************************
//
// MIDITrail / MTPianoKeyboardCtrlMod
//
// sAmL[{[hModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTPianoKeyboardCtrlMod.h"
#include "MTPianoKeyboardMod.h"
#include "MTNoteRippleMod.h"
#include "MTNoteLyrics.h"

using namespace YNBaseLib;


//******************************************************************************
// p[^`
//******************************************************************************
#define MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM (256)


//******************************************************************************
// RXgN^
//******************************************************************************
MTPianoKeyboardCtrlMod::MTPianoKeyboardCtrlMod(void)
{
	m_MaxPortIndex = 0;
	ZeroMemory(m_KeyDownRateMod, sizeof(float) * SM_MAX_CH_NUM* SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTPianoKeyboardCtrlMod::~MTPianoKeyboardCtrlMod(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
int MTPianoKeyboardCtrlMod::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData,
		MTNotePitchBend* pNotePitchBend,
		bool isSingleKeyboard
	)
{
	int result = 0;
	unsigned long index = 0;
	unsigned long portIndex = 0;
	unsigned char portNo = 0;
	SMTrack track;

	Release();

	if (pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//m[gfUCIuWFNg
	result = m_NoteDesignMod.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//L[{[hfUC
	result = m_KeyboardDesignMod.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//V[PXf[^F|[gXg擾
	result = pSeqData->GetPortList(&m_PortList);
	if (result != 0) goto EXIT;

	//|[gԍɏ̃CfbNXU
	//|[g 0 3 5 ɏo͂ꍇ̃CfbNX͂ꂼ 0, 1, 2
	for (index = 0; index < SM_MAX_PORT_NUM; index++) {
		m_PortIndex[index] = -1;
	}
	for (index = 0; index < m_PortList.GetSize(); index++) {
		m_PortList.GetPort(index, &portNo);
		m_PortIndex[portNo] = portIndex;
		portIndex++;
		if(portIndex == m_KeyboardDesignMod.GetKeyboardMaxDispNum()){
			break;
		}
	}
	m_MaxPortIndex = (unsigned char)portIndex;

	//gbN擾
	result = pSeqData->GetMergedTrack(&track);
	if (result != 0) goto EXIT;

	//m[gXg擾FstartTime, endTime ̓A^C(msec)
	result = track.GetNoteListWithRealTime(&m_NoteListRT, pSeqData->GetTimeDivision());
	if (result != 0) goto EXIT;

	//m[gz񐶐
	result = _CreateNoteStatus();
	if (result != 0) goto EXIT;

	//L[{[h
	result = _CreateKeyboards(pD3DDevice, pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//sb`xh
	m_pNotePitchBend = pNotePitchBend;

	//VOL[{[htO
	//tO󂯎ĂgpȂB|[gʃVOL[{[hŏɓ삷
	m_isSingleKeyboard = isSingleKeyboard;

EXIT:;
	return result;
}

//******************************************************************************
// L[{[h`IuWFNg
//******************************************************************************
int MTPianoKeyboardCtrlMod::_CreateKeyboards(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData
	)
{
	int result = 0;
	unsigned char portIndex = 0;
	LPDIRECT3DTEXTURE9 pTexture = NULL;

	for (portIndex = 0; portIndex < m_MaxPortIndex; portIndex++) {
		try {
			m_pPianoKeyboard[portIndex] = new MTPianoKeyboardMod;
		}
		catch (std::bad_alloc) {
			result = YN_SET_ERR("Could not allocate memory.", 0, 0);
			goto EXIT;
		}

		result = m_pPianoKeyboard[portIndex]->Create(pD3DDevice, pSceneName, pSeqData, pTexture);
		if (result != 0) goto EXIT;

		//擪IuWFNgō쐬eNX`ėp
		pTexture = m_pPianoKeyboard[portIndex]->GetTexture();
	}

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTPianoKeyboardCtrlMod::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	unsigned char portNo = 0;
	unsigned char chNo = 0;
	D3DXVECTOR3 vectorLU;
	D3DXVECTOR3 vectorRU;
	D3DXVECTOR3 vectorLD;
	D3DXVECTOR3 vectorRD;
	D3DXVECTOR3 moveVector1;
	D3DXVECTOR3 moveVector2;

	//ݔm[g̒_XV
	result = _TransformActiveNotes(pD3DDevice);
	if (result != 0) goto EXIT;

	//Đʒ_W擾
	m_NoteDesignMod.GetPlaybackSectionVirtexPos(
			0,
			&vectorLU,
			&vectorRU,
			&vectorLD,
			&vectorRD
		);

	float boardHeight = vectorLU.y - vectorLD.y;
	float keyboardWidth = m_KeyboardDesignMod.GetPortOriginX(0) * -2.0f;

	float rippleSpacing = m_NoteDesignMod.GetRippleSpacing();

	//ړxNgFĐʂɒǏ]
	moveVector2 = m_NoteDesignMod.GetWorldMoveVector();
	moveVector2.x += m_NoteDesignMod.GetPlayPosX(m_CurTickTime);

	unsigned char lastPortNo = 0;

	m_PortList.GetPort(m_PortList.GetSize()-1, &lastPortNo);

	for(portNo = 0; portNo <= lastPortNo; portNo ++) {

		int portIndex = m_PortIndex[portNo];

		if(portIndex == -1) {
			continue;
		}

		//sb`xhVtg̍őʂ߂
		float maxAbsPitchBendShift = 0.0f;
		float curMaxPitchBendShift = 0.0f;

		for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {

			float pitchBendShift = _GetPichBendShiftPosX(portNo, chNo);
			if(maxAbsPitchBendShift < fabs(pitchBendShift)) {

				curMaxPitchBendShift = pitchBendShift;
				maxAbsPitchBendShift = fabs(pitchBendShift);
			}
		}

		//ړxNgFL[{[hW
		moveVector1 = m_KeyboardDesignMod.GetKeyboardBasePos(portIndex, 0, keyboardWidth / boardHeight);

		//ړxNgFsb`xhVtg𔽉f
		moveVector1.x += curMaxPitchBendShift;

		if(rollAngle < 0.0f) {
			rollAngle += 360.0f;
		}

		float portWidth =  m_KeyboardDesignMod.GetChStep() * 16.0f;

		if((rollAngle > 120.0f) && (rollAngle < 300.0f)) {

			//Ղ1/2̕
			moveVector1.x += m_KeyboardDesignMod.GetWhiteKeyStep() / 2.0f;

			//|[g_Y
			moveVector1.y -= portWidth * (m_PortList.GetSize() - portIndex - 1) * (keyboardWidth / boardHeight);

			//Ղ̌_Ch15
			moveVector1.y -= m_KeyboardDesignMod.GetChStep()  * (keyboardWidth / boardHeight) * 15.0f;

			//Ղ1/4̍
			moveVector1.y -= m_KeyboardDesignMod.GetWhiteKeyHeight() / 4.0f;

			//Ղ̒{bv}[W{̎}[WO
			moveVector1.z -= m_KeyboardDesignMod.GetWhiteKeyLen() + rippleSpacing * (MTNOTELYRICS_MAX_LYRICS_NUM + MTNOTERIPPLE_MAX_RIPPLE_NUM) * (keyboardWidth / boardHeight);

		} else {

			//Ղ1/2̕
			moveVector1.x += m_KeyboardDesignMod.GetWhiteKeyStep() / 2.0f;

			//|[g_Y
			moveVector1.y += portWidth * (m_PortList.GetSize() - portIndex - 1) * (keyboardWidth / boardHeight);

			//Ղ1/4̍
			moveVector1.y -= m_KeyboardDesignMod.GetWhiteKeyHeight() / 4.0f;

			//bv}[W{̎}[W
			moveVector1.z += 0.002f * (MTNOTELYRICS_MAX_LYRICS_NUM + MTNOTERIPPLE_MAX_RIPPLE_NUM) * (keyboardWidth / boardHeight);
		}

		//L[{[hړ
		result = m_pPianoKeyboard[portIndex]->Transform(pD3DDevice, moveVector1, moveVector2, boardHeight / keyboardWidth, vectorLU.z, rollAngle);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[gԍXV
//******************************************************************************
int MTPianoKeyboardCtrlMod::_UpdateNoteStatus(
		unsigned long playTimeMSec,
		unsigned long keyDownDuration,
		unsigned long keyUpDuration,
		SMNote note,
		NoteStatus* pNoteStatus
	)
{
	int result= 0;

	//m[gONOiL[~j
	if (playTimeMSec < note.startTime) {
		pNoteStatus->keyStatus = BeforeNoteON;
		if (keyDownDuration == 0) {
			pNoteStatus->keyDownRate = 0.0f;
		}
		else {
			pNoteStatus->keyDownRate = 1.0f - ((float)(note.startTime - playTimeMSec) / (float)keyDownDuration);
		}
	}
	//m[gONOFF܂
	else if ((note.startTime <= playTimeMSec) && (playTimeMSec <= note.endTime)) {
		pNoteStatus->keyStatus = NoteON;
		pNoteStatus->keyDownRate = 1.0f;
	}
	//m[gOFFiL[㏸j
	else if ((note.endTime < playTimeMSec) && (playTimeMSec <= (note.endTime + keyUpDuration))) {
		pNoteStatus->keyStatus = AfterNoteOFF;
		if (keyUpDuration == 0) {
			pNoteStatus->keyDownRate = 0.0f;
		}
		else {
			pNoteStatus->keyDownRate = 1.0f - ((float)(playTimeMSec - note.endTime) / (float)keyUpDuration);
		}
	}
	//m[gOFFiL[Aς݁j
	else {
		//m[gj
		//`l̃L[Ԃ|[gʂɏW񂷂
		result = m_pPianoKeyboard[m_PortIndex[note.portNo]]->ResetKey(note.noteNo);
		if (result != 0) goto EXIT;

		pNoteStatus->isActive = false;
		pNoteStatus->keyStatus = BeforeNoteON;
		pNoteStatus->index = 0;
		pNoteStatus->keyDownRate = 0.0f;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_XV
//******************************************************************************
int MTPianoKeyboardCtrlMod::_UpdateVertexOfActiveNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long elapsedTime = 0;
	SMNote note;
	D3DXCOLOR noteColor;

	ZeroMemory(m_KeyDownRateMod, sizeof(float) * SM_MAX_CH_NUM* SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);

	//m[gɂĒ_XV
	for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
		//łȂ΃XLbv
		if (!(m_pNoteStatus[i].isActive)) continue;

		//m[g擾
		result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
		if (result != 0) goto EXIT;

		//Jňoߎ
		elapsedTime = 0;
		if (m_pNoteStatus[i].keyStatus == NoteON) {
			elapsedTime = m_PlayTimeMSec - note.startTime;
		}

		//m[g̐F
		noteColor = m_NoteDesignMod.GetNoteBoxColor(note.portNo, note.chNo, note.noteNo);
		
		//ΏۃL[]
		//  łɓm[gɑ΂Ē_XVĂꍇ
		//  OꍇɌ蒸_XV
		if (m_KeyDownRateMod[note.portNo][note.chNo][note.noteNo] < m_pNoteStatus[i].keyDownRate) {
			//`l̃L[Ԃ|[gʂɏW񂷂
			result = m_pPianoKeyboard[m_PortIndex[note.portNo]]->PushKey(
																	note.chNo,
																	note.noteNo,
																	m_pNoteStatus[i].keyDownRate,
																	elapsedTime,
																	&noteColor
																);
			if (result != 0) goto EXIT;
			m_KeyDownRateMod[note.portNo][note.chNo][note.noteNo] = m_pNoteStatus[i].keyDownRate;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTPianoKeyboardCtrlMod::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	unsigned char portIndex = 0;
	unsigned long count = 0;
	unsigned long dispNum = 0;

	if (!m_isEnable) goto EXIT;

	//L[{[h̕`
	for (portIndex = 0; portIndex < m_MaxPortIndex; portIndex++) {

		result = m_pPianoKeyboard[portIndex]->Draw(pD3DDevice);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTPianoKeyboardCtrlMod::Reset()
{
	int result = 0;
	unsigned long i = 0;
	SMNote note;

	m_PlayTimeMSec = 0;
	m_CurTickTime = 0;
	m_CurNoteIndex = 0;

	for (i = 0; i < MTPIANOKEYBOARD_MAX_ACTIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
			//if (result != 0) goto EXIT;

			//`l̃L[Ԃ|[gʂɏW񂷂
			result = m_pPianoKeyboard[m_PortIndex[note.portNo]]->ResetKey(note.noteNo);
			//if (result != 0) goto EXIT;
		}
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].keyStatus = BeforeNoteON;
		m_pNoteStatus[i].index = 0;
		m_pNoteStatus[i].keyDownRate = 0.0f;
	}

	return;
}
