//******************************************************************************
//
// MIDITrail / MTNoteRippleMod
//
// m[gg`ModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTNoteRipple.h"
#include "MTNoteDesignMod.h"


//******************************************************************************
// p[^`
//******************************************************************************
//ő|[g
#define MTNOTERIPPLE_MAX_PORT_NUM  (8)


//******************************************************************************
// m[gg`ModNX
//******************************************************************************
class MTNoteRippleMod : public MTNoteRipple
{
public:

	//RXgN^^fXgN^
	MTNoteRippleMod(void);
	virtual ~MTNoteRippleMod(void);

	//
	virtual int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend
		);

	//`
	virtual int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	virtual void Release();

	//tԐݒ
	void SetPlayTimeMSec(unsigned long playTimeMsec);

	//Zbg
	virtual void Reset();

protected:

	virtual int _CreateNoteStatus();
	virtual int _CreateVertex(LPDIRECT3DDEVICE9 pD3DDevice);
	virtual void _MakeMaterial(D3DMATERIAL9* pMaterial);
	virtual int _TransformRipple(LPDIRECT3DDEVICE9 pD3DDevice);
	virtual int _UpdateVertexOfRipple(LPDIRECT3DDEVICE9 pD3DDevice);

private:

	//m[gԍ\
	//L[
	enum KeyStatus {
		BeforeNoteON,
		NoteON,
		AfterNoteOFF
	};

	//m[g\
	struct NoteStatusMod {
		bool isActive;
		KeyStatus keyStatus;
		unsigned long index;
		float keyDownRate;
	};

private:

	//m[gfUC
	MTNoteDesignMod m_NoteDesignMod;

	//m[gXg
	SMNoteList m_NoteListRT;

	//m[gǗ
	unsigned long m_PlayTimeMSec;
	unsigned long m_CurNoteIndex;
	float m_KeyDownRate[MTNOTERIPPLE_MAX_PORT_NUM][SM_MAX_CH_NUM][SM_MAX_NOTE_NUM];

	//m[gԏ
	NoteStatusMod* m_pNoteStatusMod;

	int _SetVertexPosition(
				MTNOTERIPPLE_VERTEX* pVertex,
				SMNote note,
				NoteStatusMod* pNoteStatus,
				unsigned long rippleNo
			);
	int _UpdateStatusOfRipple(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateNoteStatus(
				unsigned long playTimeMSec,
				unsigned long decayDuration,
				unsigned long releaseDuration,
				SMNote note,
				NoteStatusMod* pNoteStatus
			);
};


