//******************************************************************************
//
// MIDITrail / MTNoteLyrics
//
// m[g̎`NX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTParam.h"
#include "MTConfFile.h"
#include "MTNoteLyrics.h"
#include <new>

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteLyrics::MTNoteLyrics(void)
{
	m_pNoteStatus = NULL;
	m_PlayTimeMSec = 0;
	m_CurTickTime = 0;
	m_CurNoteIndex = 0;
	m_ActiveNoteNum = 0;
	m_CamVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	ZeroMemory(&m_Material, sizeof(D3DMATERIAL9));
	m_isEnable = true;
	m_isSkipping = false;
	ZeroMemory(m_KeyDownRate, sizeof(float) * MTNOTELYRICS_MAX_PORT_NUM * SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteLyrics::~MTNoteLyrics(void)
{
	Release();
}

//******************************************************************************
// m[g̎
//******************************************************************************
int MTNoteLyrics::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		SMSeqData* pSeqData,
		MTNotePitchBend* pNotePitchBend
   )
{
	int result = 0;
	SMTrack track;

	Release();

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	//gbN擾
	result = pSeqData->GetMergedTrack(&track);
	if (result != 0) goto EXIT;

	//m[gXg擾FstartTime, endTime ̓A^C(msec)
	result = track.GetNoteListWithRealTime(&m_NoteListRT, pSeqData->GetTimeDivision());
	if (result != 0) goto EXIT;

	//m[gz񐶐
	result = _CreateNoteStatus();
	if (result != 0) goto EXIT;

	//_
	result = _CreateVertex(pD3DDevice);
	if (result != 0) goto EXIT;

	//}eA쐬
	_MakeMaterial(&m_Material);

	//sb`xh
	m_pNotePitchBend = pNotePitchBend;

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTNoteLyrics::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXVECTOR3 camVector,
		float rollAngle
	)
{
	int result = 0;
	D3DXVECTOR3 moveVector;
	D3DXMATRIX rotateMatrix;
	D3DXMATRIX moveMatrix;
	D3DXMATRIX worldMatrix;

	m_CamVector = camVector;

	//̎̒_XV
	result = _TransformLyrics(pD3DDevice);
	if (result != 0) goto EXIT;

	//s񏉊
	D3DXMatrixIdentity(&rotateMatrix);
	D3DXMatrixIdentity(&moveMatrix);
	D3DXMatrixIdentity(&worldMatrix);

	//]s
	//D3DXMatrixRotationX(&rotateMatrix, D3DXToRadian(rollAngle + 180.0f));
	D3DXMatrixRotationX(&rotateMatrix, D3DXToRadian(rollAngle));

	//ړs
	moveVector = m_NoteDesign.GetWorldMoveVector();
	D3DXMatrixTranslation(&moveMatrix, moveVector.x, moveVector.y, moveVector.z);

	//s̍
	D3DXMatrixMultiply(&worldMatrix, &rotateMatrix, &moveMatrix);

	//ϊsݒ
	m_Primitive.Transform(worldMatrix);

EXIT:;
	return result;
}

//******************************************************************************
// ̎̒_XV
//******************************************************************************
int MTNoteLyrics::_TransformLyrics(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;

	//XLbvȂ牽Ȃ
	if (m_isSkipping) goto EXIT;

	//̎̏ԍXV
	result = _UpdateStatusOfLyrics(pD3DDevice);
	if (result != 0) goto EXIT;

	//̎̒_XV
	result = _UpdateVertexOfLyrics(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ̎̏ԍXV
//******************************************************************************
int MTNoteLyrics::_UpdateStatusOfLyrics(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	bool isFound = false;
	bool isRegist = false;
	SMNote note;

	//̎fBPCE[X(msec)
	unsigned long decayDuration = m_NoteDesign.GetRippleDecayDuration();
	unsigned long releaseDuration   = m_NoteDesign.GetRippleReleaseDuration();

	//m[gXV
	for (i = 0; i < MTNOTELYRICS_MAX_LYRICS_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			//m[g擾
			result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
			if (result != 0) goto EXIT;

			//m[gԍXV
			result = _UpdateNoteStatus(
							m_PlayTimeMSec,
							decayDuration,
							releaseDuration,
							note,
							&(m_pNoteStatus[i])
						);
			if (result != 0) goto EXIT;
		}
	}

	//O񌟍Iʒu甭Jnm[g
	while (m_CurNoteIndex < m_NoteListRT.GetSize()) {
		//m[g擾
		result = m_NoteListRT.GetNote(m_CurNoteIndex, &note);
		if (result != 0) goto EXIT;

		//tԂL[JnԁiJnOjɂǂĂȂΌI
		if (m_PlayTimeMSec < note.startTime) {
			break;
		}

		//m[go^
		isRegist = false;
		if ((note.startTime <= m_PlayTimeMSec) && (m_PlayTimeMSec <= note.endTime) && (note.lyric[0] != '\0')) {
			isRegist = true;
		}

		//m[go^
		//  L[~^㏸̏o^ΏۂƂĂ邽
		//  m[gŕGgꍇ邱Ƃɒӂ
		if (isRegist) {
			//łɓCfbNXœo^ς݂̏ꍇ͉Ȃ
			isFound = false;
			for (i = 0; i < MTNOTELYRICS_MAX_LYRICS_NUM; i++) {
				if ((m_pNoteStatus[i].isActive)
				 && (m_pNoteStatus[i].index == m_CurNoteIndex)) {
					isFound = true;
					break;
				}
			}
			//󂢂ĂƂɒǉ
			if (!isFound) {
				for (i = 0; i < MTNOTELYRICS_MAX_LYRICS_NUM; i++) {
					if (!(m_pNoteStatus[i].isActive)) {
						m_pNoteStatus[i].isActive = true;
						m_pNoteStatus[i].index = m_CurNoteIndex;
						m_pNoteStatus[i].keyStatus = BeforeNoteON;
						m_pNoteStatus[i].keyDownRate = 0.0f;

						m_pNoteStatus[i].fontTexture.SetFont(_T("HGSSoeiKakugothicUB"), 64, 0x00FFFFFF, false);
						m_pNoteStatus[i].fontTexture.CreateTexture(pD3DDevice, note.lyric);
						break;
					}
				}
			}
			//m[gԍXV
			result = _UpdateNoteStatus(
							m_PlayTimeMSec,
							decayDuration,
							releaseDuration,
							note,
							&(m_pNoteStatus[i])
						);
			if (result != 0) goto EXIT;
		}
		m_CurNoteIndex++;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[gԍXV
//******************************************************************************
int MTNoteLyrics::_UpdateNoteStatus(
		unsigned long playTimeMSec,
		unsigned long decayDuration,
		unsigned long releaseDuration,
		SMNote note,
		NoteStatus* pNoteStatus
	)
{
	int result= 0;

	//Im[g
	if(playTimeMSec > note.endTime) {
		//m[gj
		pNoteStatus->isActive = false;
		pNoteStatus->index = 0;
		pNoteStatus->keyStatus = BeforeNoteON;
		pNoteStatus->keyDownRate = 0.0f;
		pNoteStatus->fontTexture.Clear();

		goto EXIT;
	}

	unsigned long noteLen = note.endTime - note.startTime;

	float decayRatio = 0.3f;
	float sustainRatio = 0.4f;
	float releaseRatio = 0.3f;

	//̎fBPCԂ蒷ꍇAfBPCԂ܂łɏC
	if(noteLen < decayDuration) {

		//decayDuration = noteLen;
		//releaseDuration = 0;

		//decayRatio = 0.3f;
		//sustainRatio = 0.0f;
		//releaseRatio = 0.0f;
	}
	//̎fBPC{[XԂ蒷ꍇA[XJnԂfBPCԌoߒɏC
	else if(noteLen < (decayDuration + releaseDuration)) {

		releaseDuration = noteLen - decayDuration;
		decayRatio = 0.5f;
		sustainRatio = 0.0f;
		releaseRatio = 0.5f;
	}
	//i̎fBPC{[Xԁj~Qȓ̏ꍇA؂ւ_fBPCIԂƃ[XJnԂ̒Ԃɂ
	else if(noteLen < (decayDuration + releaseDuration) * 2) {

		unsigned long midTime = (note.startTime + decayDuration) / 2 + (note.endTime - releaseDuration) / 2;

		decayDuration = midTime - note.startTime;
		releaseDuration = note.endTime - midTime;

		decayRatio = 0.5f;
		sustainRatio = 0.0f;
		releaseRatio = 0.5f;
	}

	//m[gONij
	if (playTimeMSec < (note.startTime + decayDuration)) {
		pNoteStatus->keyStatus = BeforeNoteON;
		if (decayDuration == 0) {
			pNoteStatus->keyDownRate = 0.0f;
		}
		else {
			pNoteStatus->keyDownRate = decayRatio * (float)(playTimeMSec - note.startTime) / (float)decayDuration;
		}
	}
	//m[gONォ烊[XO܂
	else if (((note.startTime + decayDuration) <= playTimeMSec)
			&& (playTimeMSec <= (note.endTime - releaseDuration))) {
		pNoteStatus->keyStatus = NoteON;

		unsigned long denominator = noteLen - (decayDuration + releaseDuration);
		if(denominator > 0) {
			pNoteStatus->keyDownRate = decayRatio + sustainRatio
					* (float)(playTimeMSec - (note.startTime + decayDuration)) / (float)denominator;
		} else {
			pNoteStatus->keyDownRate = decayRatio + sustainRatio;
		}
	}
	//m[gOFFOi[Xj
	else if (((note.endTime - releaseDuration) < playTimeMSec) && (playTimeMSec <= note.endTime)) {
		pNoteStatus->keyStatus = AfterNoteOFF;
		if (releaseDuration == 0) {
			pNoteStatus->keyDownRate = 1.0f;
		}
		else {
			pNoteStatus->keyDownRate = decayRatio + sustainRatio + releaseRatio
					* (float)(playTimeMSec - (note.endTime - releaseDuration)) / (float)releaseDuration;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// ̎̒_XV
//******************************************************************************
int MTNoteLyrics::_UpdateVertexOfLyrics(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	MTNOTELYRICS_VERTEX* pVertex = NULL;
	D3DXMATRIX mtxWorld;
	unsigned long i = 0;
	unsigned long activeNoteNum = 0;
	bool isTimeout = false;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;

	ZeroMemory(m_KeyDownRate, sizeof(float) * MTNOTELYRICS_MAX_PORT_NUM * SM_MAX_CH_NUM * SM_MAX_NOTE_NUM);

	//m[g̉̎ɂĒ_XV
	for (i = 0; i < MTNOTELYRICS_MAX_LYRICS_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			//m[g擾
			SMNote note;
			result = m_NoteListRT.GetNote(m_pNoteStatus[i].index, &note);
			if (result != 0) goto EXIT;

			//ΏۃL[]
			//  łɓm[gɑ΂Ē_XVĂꍇ
			//  OꍇɌ蒸_XV
			if ((note.portNo < MTNOTELYRICS_MAX_PORT_NUM)
			 && (m_KeyDownRate[note.portNo][note.chNo][note.noteNo] < m_pNoteStatus[i].keyDownRate)) {
				//_XVF̎̕`ʒuƃTCYς
				_SetVertexPosition(
						&(pVertex[activeNoteNum*6]),	//_obt@݈ʒu
						note,							//m[g
						&(m_pNoteStatus[i]),			//m[g
						i								//m[gԓo^CfbNXʒu
					);
				m_pTextures[activeNoteNum] = m_pNoteStatus[i].fontTexture.GetTexture();
		 		activeNoteNum++;

				m_KeyDownRate[note.portNo][note.chNo][note.noteNo] = m_pNoteStatus[i].keyDownRate;
			}

		}
	}
	m_ActiveNoteNum = activeNoteNum;

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTNoteLyrics::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	if (!m_isEnable) goto EXIT;

	//eNX`Xe[Wݒ
	//  J[ZFZ  1FeNX`  2F|S
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_MODULATE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
	// At@ZF1gp  1F|S
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	//eNX`tB^
	pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	//_OXe[gݒFZ
	//pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
	pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);

	//v~eBu`
	if (m_ActiveNoteNum > 0) {
		//obt@ŜłȂ̎̐ɍ킹ĕ`悷v~eBu炷
		result = m_Primitive.DrawLyrics(pD3DDevice, m_pTextures, 2 * m_ActiveNoteNum);
		if (result != 0) goto EXIT;
	}

	//_OXe[gݒFʏ̃At@
	//pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTNoteLyrics::Release()
{
	m_Primitive.Release();

	delete [] m_pNoteStatus;
	m_pNoteStatus = NULL;
}

//******************************************************************************
// m[gz񐶐
//******************************************************************************
int MTNoteLyrics::_CreateNoteStatus()
{
	int result = 0;
	unsigned long i = 0;

	//m[gz񐶐
	try {
		m_pNoteStatus = new NoteStatus[MTNOTELYRICS_MAX_LYRICS_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	//ZeroMemory(m_pNoteStatus, sizeof(NoteStatus) * MTNOTELYRICS_MAX_LYRICS_NUM);

	for (i = 0; i < MTNOTELYRICS_MAX_LYRICS_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].keyStatus = BeforeNoteON;
		m_pNoteStatus[i].index = 0;
		m_pNoteStatus[i].keyDownRate = 0.0f;
	}

EXIT:;
	return result;
}

//******************************************************************************
// _
//******************************************************************************
int MTNoteLyrics::_CreateVertex(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long vertexNum = 0;
	MTNOTELYRICS_VERTEX* pVertex = NULL;

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTNOTELYRICS_VERTEX),//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_TRIANGLELIST			//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = 6 * MTNOTELYRICS_MAX_LYRICS_NUM;
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;

	ZeroMemory(pVertex, sizeof(MTNOTELYRICS_VERTEX) * 6 * MTNOTELYRICS_MAX_LYRICS_NUM);

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// _̍Wݒ
//******************************************************************************
int MTNoteLyrics::_SetVertexPosition(
		MTNOTELYRICS_VERTEX* pVertex,
		SMNote note,
		NoteStatus* pNoteStatus,
		unsigned long rippleNo
	)
{
	int result = 0;
	unsigned long i = 0;
	float rh, rw = 0.0f;
	float alpha = 0.0f;
	D3DXVECTOR3 center;
	D3DXCOLOR color;
	short pbValue = 0;
	unsigned char pbSensitivity = SM_DEFAULT_PITCHBEND_SENSITIVITY;

	pbValue =       m_pNotePitchBend->GetValue(note.portNo, note.chNo);
	pbSensitivity = m_pNotePitchBend->GetSensitivity(note.portNo, note.chNo);

	//m[g{bNXSW擾
	center = m_NoteDesign.GetNoteBoxCenterPosX(
					m_CurTickTime,
					note.portNo,
					note.chNo,
					note.noteNo,
					pbValue,
					pbSensitivity
				);

	//̎TCY
	unsigned long tx, ty;
	pNoteStatus->fontTexture.GetTextureSize(&tx, &ty);
	rh = tx * m_NoteDesign.GetDecayCoefficient(pNoteStatus->keyDownRate) / 64.0f;
	rw = ty * m_NoteDesign.GetDecayCoefficient(pNoteStatus->keyDownRate) / 64.0f;

	//`ImF
	if ((rh <= 0.0f) || (rw <= 0.0f)) {
		goto EXIT;
	}

	//̎ĐʏォJɏĕ`悷
	//܂̎mꕽʏŏdȂȂ悤ɕ`悷
	//  Zt@CeBOɂĔ邿₩
	//  OtBbNJ[hɂČۂقȂ
	if (center.x < m_CamVector.x) {
		center.x -= 0.002f * MTNOTELYRICS_MAX_LYRICS_NUM - (rippleNo + 1) * 0.002f;
	}
	else {
		center.x -= (rippleNo + 1) * 0.002f;
	}


	//_W
	//pVertex[0].p = D3DXVECTOR3(center.x, center.y+(rh/2.0f), center.z+(rw/2.0f));
	//pVertex[1].p = D3DXVECTOR3(center.x, center.y+(rh/2.0f), center.z-(rw/2.0f));
	//pVertex[2].p = D3DXVECTOR3(center.x, center.y-(rh/2.0f), center.z+(rw/2.0f));
	//pVertex[3].p = pVertex[2].p;
	//pVertex[4].p = pVertex[1].p;
	//pVertex[5].p = D3DXVECTOR3(center.x, center.y-(rh/2.0f), center.z-(rw/2.0f));
	pVertex[0].p = D3DXVECTOR3(center.x, center.y+(rh/2.0f), center.z-(rw/2.0f));
	pVertex[1].p = D3DXVECTOR3(center.x, center.y+(rh/2.0f), center.z+(rw/2.0f));
	pVertex[2].p = D3DXVECTOR3(center.x, center.y-(rh/2.0f), center.z+(rw/2.0f));
	pVertex[3].p = pVertex[0].p;
	pVertex[4].p = pVertex[2].p;
	pVertex[5].p = D3DXVECTOR3(center.x, center.y-(rh/2.0f), center.z-(rw/2.0f));
	//@
	for (i = 0; i < 6; i++) {
		pVertex[i].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	}

	//xXɗƂ
	alpha = m_NoteDesign.GetRippleAlpha(pNoteStatus->keyDownRate);

	//e_̃fBt[YF
	for (i = 0; i < 6; i++) {
		color = m_NoteDesign.GetNoteBoxColor(
								note.portNo,
								note.chNo,
								note.noteNo
							);
		pVertex[i].c = D3DXCOLOR(color.r, color.g, color.b, alpha);
	}

	//eNX`W
	//pVertex[0].t = D3DXVECTOR2(0.0f, 0.0f);
	//pVertex[1].t = D3DXVECTOR2(1.0f, 0.0f);
	//pVertex[2].t = D3DXVECTOR2(0.0f, 1.0f);
	//pVertex[3].t = pVertex[2].t;
	//pVertex[4].t = pVertex[1].t;
	//pVertex[5].t = D3DXVECTOR2(1.0f, 1.0f);
	pVertex[0].t = D3DXVECTOR2(1.0f, 0.0f);
	pVertex[1].t = D3DXVECTOR2(0.0f, 0.0f);
	pVertex[2].t = D3DXVECTOR2(0.0f, 1.0f);
	pVertex[3].t = pVertex[0].t;
	pVertex[4].t = pVertex[2].t;
	pVertex[5].t = D3DXVECTOR2(1.0f, 1.0f);

EXIT:
	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTNoteLyrics::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));
	
	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 10.0f;
	//F
	pMaterial->Emissive.r = 0.5f;
	pMaterial->Emissive.g = 0.5f;
	pMaterial->Emissive.b = 0.5f;
	pMaterial->Emissive.a = 1.0f;
}

//******************************************************************************
// Jg`bN^Cݒ
//******************************************************************************
void MTNoteLyrics::SetCurTickTime(
		unsigned long curTickTime
	)
{
	m_CurTickTime = curTickTime;
}

//******************************************************************************
// tԐݒ
//******************************************************************************
void MTNoteLyrics::SetPlayTimeMSec(
		unsigned long playTimeMsec
	)
{
	m_PlayTimeMSec = playTimeMsec;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTNoteLyrics::Reset()
{
	unsigned long i = 0;

	m_PlayTimeMSec = 0;
	m_CurTickTime = 0;
	m_CurNoteIndex = 0;
	m_ActiveNoteNum = 0;

	for (i = 0; i < MTNOTELYRICS_MAX_LYRICS_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].index = 0;
		m_pNoteStatus[i].keyStatus = BeforeNoteON;
		m_pNoteStatus[i].keyDownRate = 0.0f;
		m_pNoteStatus[i].fontTexture.Clear();
	}

	return;
}

//******************************************************************************
// \ݒ
//******************************************************************************
void MTNoteLyrics::SetEnable(
		bool isEnable
	)
{
	m_isEnable = isEnable;
}

//******************************************************************************
// XLbvԐݒ
//******************************************************************************
void MTNoteLyrics::SetSkipStatus(
		bool isSkipping
	)
{
	m_isSkipping = isSkipping;
}


