//******************************************************************************
//
// MIDITrail / MTNoteDesignMod
//
// m[gfUCModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTNoteDesign.h"
//******************************************************************************
// m[gfUCModNX
//******************************************************************************
class MTNoteDesignMod : public MTNoteDesign
{
public:

	//RXgN^^fXgN^
	MTNoteDesignMod(void);
	virtual ~MTNoteDesignMod(void);

	//
	virtual int Initialize(const TCHAR* pSceneName, SMSeqData* pSeqData);

	//g\Ԏ擾
	unsigned long GetRippleDecayDuration();
	unsigned long GetRippleReleaseDuration();

	//g`擾
	unsigned long GetRippleOverwriteTimes();
	float GetRippleSpacing();

	//gTCY擾
	float GetRippleHeight(float rate);
	float GetRippleWidth(float rate);
	float GetRippleAlpha(float rate);
	float GetDecayCoefficient(float rate);

	//|[g_W擾
	virtual float GetPortOriginZ(unsigned char portNo);

	//m[g{bNXJ[擾
	D3DXCOLOR GetActiveNoteBoxColor(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				float rate
			);

protected:

	virtual void _Clear();
	virtual int _LoadConfFile(const TCHAR* pSceneName);

private:

	//fBPC
	int m_RippleDecayDuration;
	//[X
	int m_RippleReleaseDuration;

	//㏑
	int m_RippleOverwriteTimes;
	//`Ԋu
	float m_RippleSpacing;
};


