//******************************************************************************
//
// MIDITrail / MTNoteDesignMod
//
// m[gfUCModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "MTConfFile.h"
#include "MTNoteDesignMod.h"


//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteDesignMod::MTNoteDesignMod(void)
{
	// NX_Clear()Ă΂邽߁ANX̃RXgN^͌Ă΂Ȃ
	_Clear();
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteDesignMod::~MTNoteDesignMod(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int MTNoteDesignMod::Initialize(
		const TCHAR* pSceneName,
		SMSeqData* pSeqData
	)
{
	int result = 0;

	//NX̏Ăяo
	MTNoteDesign::Initialize(pSceneName, pSeqData);

	//p[^ݒt@Cǂݍ
	result = _LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// gfBPCԎ擾(msec)
//******************************************************************************
unsigned long MTNoteDesignMod::GetRippleDecayDuration()
{
	return (unsigned long)m_RippleDecayDuration;
}

//******************************************************************************
// g䃊[XԎ擾(msec)
//******************************************************************************
unsigned long MTNoteDesignMod::GetRippleReleaseDuration()
{
	return (unsigned long)m_RippleReleaseDuration;
}

//******************************************************************************
// g㏑
//******************************************************************************
unsigned long MTNoteDesignMod::GetRippleOverwriteTimes()
{
	return (unsigned long)m_RippleOverwriteTimes;
}

//******************************************************************************
// g`Ԋu
//******************************************************************************
float MTNoteDesignMod::GetRippleSpacing()
{
	return m_RippleSpacing;
}

//******************************************************************************
// gcTCY擾
//******************************************************************************
float MTNoteDesignMod::GetRippleHeight(
		float rate	//TCY䗦
	)
{
	return m_RippleHeight * GetDecayCoefficient(rate);
}

//******************************************************************************
// g䉡TCY擾
//******************************************************************************
float MTNoteDesignMod::GetRippleWidth(
		float rate	//TCY䗦
	)
{
	return m_RippleWidth * GetDecayCoefficient(rate);
}

//******************************************************************************
// g䓧x擾
//******************************************************************************
float MTNoteDesignMod::GetRippleAlpha(
		float rate	//TCY䗦
	)
{
	return GetDecayCoefficient(rate);
}

//******************************************************************************
// W擾
//******************************************************************************
float MTNoteDesignMod::GetDecayCoefficient(
		float rate	//TCY䗦
	)
{
	float coeff = 1.0f;

	if(rate < 0.5f) {
		coeff = (pow(2.0f, (0.5f - rate) * 8.0f) + 14.0f) / 20.0f;
	} else {
		coeff = (16.0f - pow(2.0f, (rate - 0.5f) * 8.0f)) / 20.0f;
	}

	coeff = coeff > 1.0f ? 1.0f : coeff;

	return coeff;
}

//******************************************************************************
// |[g_ZW擾
//******************************************************************************
float MTNoteDesignMod::GetPortOriginZ(
		unsigned char portNo
	)
{
	float portIndex = 0.0f;
	float portWidth = 0.0f;

	//                  +y
	//                   |
	//         portC   portB   portA
	//       +-------+-------+-------+Note#127
	//       |       |   |   |       |
	//       |       |   |   |       |
	//       |       |   |   |       |
	// +z<---|-------@---0---@-------@--------->-z
	//       |       |   |   |       |
	//       |       |   |   |       |  @:OriginZ(for portA,B,C)
	//       |       |   |   |       |
	//       +-------+-------+-------+Note#0
	//    Ch. 16    0 16 |  0 16    0
	//                   |
	//                  -y

	portIndex = (float)(m_PortIndex[portNo]);
	portWidth = GetChStep() * 15.0f;

	return ((portWidth * portIndex) - (portWidth * m_PortList.GetSize() / 2.0f));
}

//******************************************************************************
// m[g{bNXJ[擾
//******************************************************************************
D3DXCOLOR MTNoteDesignMod::GetActiveNoteBoxColor(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		float rate
	)
{
	float alpha = 1.0f;

	if(rate < 0.5f) {
		alpha = (pow(2.0f, (0.5f - rate) * 8.0f) + 14.0f) / 20.0f;
	} else {
		alpha = (16.0f - pow(2.0f, (rate - 0.5f) * 8.0f)) / 20.0f;
	}

	alpha = alpha > 1.0f ? 1.0f : alpha;

	D3DXCOLOR color;
	float r,g,b,a = 0.0f;

	color = GetNoteBoxColor(portNo, chNo, noteNo);

	//m_ActiveNoteDuration [X^C
	//  Jn_m[gFɖ߂܂ł̎
	//   m_ActiveNoteEmissive ɂă[Xm[gOFF܂Ŕ

	//m_ActiveNoteWhiteRate ő唒F
	//  0.0  m[gFωȂ
	//  0.5  m[gFƔ̒ԐF
	//  1.0  

	r = color.r + ((1.0f - color.r) * alpha * m_ActiveNoteWhiteRate);
	g = color.g + ((1.0f - color.g) * alpha * m_ActiveNoteWhiteRate);
	b = color.b + ((1.0f - color.b) * alpha * m_ActiveNoteWhiteRate);
	a = color.a;
	color = D3DXCOLOR(r, g, b, a);

	return color;
}

//******************************************************************************
// NA
//******************************************************************************
void MTNoteDesignMod::_Clear(void)
{
	MTNoteDesign::_Clear();

	m_RippleDecayDuration = 100;
	m_RippleReleaseDuration = 250;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTNoteDesignMod::_LoadConfFile(
		const TCHAR* pSceneName
	)
{
	int result = 0;
	MTConfFile confFile;

	//NX̓ǂݍݏĂяo
	result = MTNoteDesign::_LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

	//ݒt@CJ
	result = confFile.Initialize(pSceneName);
	if (result != 0) goto EXIT;

	//----------------------------------
	//g
	//----------------------------------
	result = confFile.SetCurSection(_T("Ripple"));
	if (result != 0) goto EXIT;

	//gfBPC(msec)
	result = confFile.GetInt(_T("DecayDuration"), &m_RippleDecayDuration, 100);
	if (result != 0) goto EXIT;

	//g䃊[X(msec)
	result = confFile.GetInt(_T("ReleaseDuration"), &m_RippleReleaseDuration, 250);
	if (result != 0) goto EXIT;

	//g㏑
	result = confFile.GetInt(_T("OverwriteTimes"), &m_RippleOverwriteTimes, 3);
	if (result != 0) goto EXIT;

	//g`Ԋu
	result = confFile.GetFloat(_T("Spacing"), &m_RippleSpacing, 0.002f);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

