#include <stdlib.h>
#include <string.h>
#include "hoc.h"
#include "y.tab.h"

static Symbol *symlist = 0;


Symbol *lookup(char *s) {
	Symbol *sp = symlist;
	while (sp != 0) {
		if (strcmp(sp->name, s)==0) return sp;
		sp = sp->next;
	}
	return 0;
}

Symbol *install(char *sym, int type, double val) {
	Symbol *sp;
	sp = malloc(sizeof(Symbol));

	int slen = strlen(sym);
	sp->name = malloc(slen+1);
	bzero(sp->name, slen+1);
	strncpy(sp->name, sym, slen); 

	sp->type = type;
	sp->u.val = val;
	sp->next = symlist;
	symlist = sp;
	return sp;
}

