#include <math.h>
#include <errno.h>

extern int execerror(char *, char *);
double errcheck(double, char*);

double Log(double val) {
	return errcheck(log(val), "log");
}
double Log10(double val) {
	return errcheck(log10(val), "log10");
}
double Exp(double val) {
	return errcheck(exp(val), "exp");
}
double Sqrt(double val) {
	return errcheck(sqrt(val), "sqrt");
}
double Pow(double x, double y) {
	return	errcheck(pow(x,y), "exponentiation"); 
}
double integer(double val) {
	return (double)(long)val;
}

double errcheck(double d, char *s) {
	if (errno == EDOM) {
		errno = 0;
		execerror(s, "argument out of domain");
	} else if (errno == ERANGE) {
		errno = 0;
		execerror(s, "result out of range");
	}
	return d;
}

