/*
 * stdBuffer.h
 *
 *  Created on: 2012/12/08
 *      Author: yasuoki
 */

#ifndef STDBUFFER_H_
#define STDBUFFER_H_

#include "../include/sst_types.h"
#include "buffer.h"

namespace SST {

class StdBuffer : public Buffer{
public:
	StdBuffer();
	~StdBuffer();
private:
	StdBuffer(const StdBuffer &c);
	StdBuffer &operator=(const StdBuffer &c);
public:
	virtual bool add(const char *data, ssize_t size);
	virtual size_t	size() const { return mSize - mReadPtr; }
	virtual size_t	get(char *buff, size_t buffSize);
	virtual size_t	getLine(char *buff, size_t buffSize);
	virtual size_t	getAt(char *buff, size_t start, size_t len) const;
	virtual const char *getPtr() const { return &mPtr[mReadPtr]; }
	virtual size_t	seek(size_t size);
	virtual void	clear();
	virtual bool	empty() const { return mSize == mReadPtr; }
	bool	addCapacity(ssize_t size);
protected:

	size_t	mBlock;
	size_t	mSize;
	size_t	mReadPtr;
	char *	mPtr;
};

}



#endif /* STDBUFFER_H_ */
