/*
 * stdBuffer.cpp
 *
 *  Created on: 2012/12/08
 *      Author: yasuoki
 */

#include "stdBuffer.h"
#include <stdio.h>
#include <stdarg.h>
#include <memory.h>
#include <string.h>
#include <malloc.h>
#include <assert.h>

#define BUFFER_BLOCK_SIZE 256

namespace SST {

StdBuffer::StdBuffer()
{
	mBlock		= 0;
	mSize		= 0;
	mReadPtr	= 0;
	mPtr		= NULL;
}

StdBuffer::~StdBuffer()
{
	clear();
}

bool StdBuffer::add(const char *data, ssize_t size)
{
	if( size == -1 ) {
		size  = data ? strlen(data) : 0;
	}
	ssize_t free_space = mBlock - mSize;
	if( free_space < size+1 ) {
		if( mReadPtr ) {
			memcpy(mPtr, &mPtr[mReadPtr], mSize - mReadPtr );
			mSize		= mSize - mReadPtr;
			mReadPtr	= 0;
		}
		free_space = mBlock - mSize;
		if( free_space < size+1 ) {
			size_t need = size+1 - free_space;
			size_t need_block = ((need / BUFFER_BLOCK_SIZE)+1)*BUFFER_BLOCK_SIZE;
			size_t new_block = mBlock + need_block;
			char *new_ptr = (char*)realloc(mPtr, new_block);
			if( new_ptr == NULL ) {
				return false;
			}
			mPtr	= new_ptr;
			mBlock	= new_block;
		}
	}
	if( size != 0) {
		memcpy(&mPtr[mSize], data, size);
		mSize += size;
		mPtr[mSize] = 0;
	}
	return true;
}

bool StdBuffer::addCapacity(ssize_t size)
{
	ssize_t free_space = mBlock - mSize;
	if( free_space < size+1 ) {
		if( mReadPtr ) {
			memcpy(mPtr, &mPtr[mReadPtr], mSize - mReadPtr );
			mSize		= mSize - mReadPtr;
			mReadPtr	= 0;
		}
		free_space = mBlock - mSize;
		if( free_space < size+1 ) {
			size_t need = size+1 - free_space;
			size_t need_block = ((need / BUFFER_BLOCK_SIZE)+1)*BUFFER_BLOCK_SIZE;
			size_t new_block = mBlock + need_block;
			char *new_ptr = (char*)realloc(mPtr, new_block);
			if( new_ptr == NULL ) {
				return false;
			}
			mPtr	= new_ptr;
			mBlock	= new_block;
		}
	}
	return true;
}

size_t StdBuffer::get(char *buff, size_t buffSize)
{
	size_t nc = (mSize - mReadPtr) < buffSize ? (mSize-mReadPtr) : buffSize;
	if( nc ) {
		memcpy(buff, &mPtr[mReadPtr], nc);
	}
	mReadPtr += nc;
	if( mReadPtr == mSize ) {
		mSize		= 0;
		mReadPtr	= 0;
	}
	return nc;
}

size_t StdBuffer::getLine(char *buff, size_t buffSize)
{
	char *dp = &mPtr[mReadPtr];
	size_t bs = mSize - mReadPtr;
	size_t nc = 0;
	size_t nr = 0;
	while(nc < buffSize-1 && nc < bs ) {
		if( *dp == '\r' || *dp == '\n' ) {
			*buff++ = '\n';
			nc++;
			nr += 2;
			break;
		}
		*buff++ = *dp++;
		nc++;
		nr++;
	}
	*buff = 0;
	if( nr != 0 ) {
		mReadPtr += nr;
		if( mReadPtr == mSize ) {
			mSize		= 0;
			mReadPtr	= 0;
		}
	}
	return nc;
}

size_t StdBuffer::getAt(char *buff, size_t start, size_t len) const
{
	size_t bs = mSize - mReadPtr;
	size_t nc = (bs - start) < len ? (bs - start) : len;
	if( nc > 0 ) {
		memcpy(buff, &mPtr[start+mReadPtr], nc);
	}
	buff[nc] = 0;
	return nc;
}

size_t StdBuffer::seek(size_t size)
{
	size_t bs = mSize - mReadPtr;
	size_t nc = bs < size ? bs : size;
	if( nc > 0 ) {
		mReadPtr += nc;
		if( mReadPtr == mSize ) {
			mSize		= 0;
			mReadPtr	= 0;
		}
	}
	return nc;
}

void StdBuffer::clear()
{
	if( mBlock != 0 )
		free(mPtr);
	mBlock		= 0;
	mSize		= 0;
	mReadPtr	= 0;
	mPtr		= NULL;
}


}



