/*
 * session.h
 *
 *  Created on: 2012/06/05
 *      Author: yasuoki
 */

#ifndef SESSION_H_
#define SESSION_H_

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <event2/event.h>
#include "../include/sst_types.h"
#include "lock.h"
#include "pjson.h"
#include "linklist.h"
#include "stdBuffer.h"

namespace SST {

class Session {
public:
	friend class SessionPool;
	Session();
	Session(const Session &c);
	~Session();
	Session &operator=(const Session &c);

	Sentinel *	getSentinel() const { return mSentinel; }
	Link &		getLink();
	bool		open(Sentinel *sentinel, int fd, sockaddr_in *addr);
	void 		close();

	SessionStatus	getStatus() const;
	void		setStatus(SessionStatus s);
	time_t		getStartTime() const { return mStart; }
	time_t		getLastTime() const { return mLastReciveTime; }

	char *		createNonce();
	const char *getLastNonce() const { return mNonce; }
	bool		setUserId(const char *id) {
		if( id )
			strcpy(mUserId, id);
		else
			mUserId[0] = 0;
		return true;
	}
	const char *getUserId() const { return mUserId[0] == 0 ? NULL : mUserId; }
	bool		setPaswdId(const char *id) {
		if( id )
			strcpy(mPasswd, id);
		else
			mPasswd[0] = 0;
		return true;
	}
	const char *getPasswd() const { return mPasswd[0] == 0 ? NULL : mPasswd; }
	bool		setAccountId(const char *id) {
		if( id )
			strcpy(mAccountId, id);
		else
			mAccountId[0] = 0;
		return true;
	}
	const char *getAccountId() const { return mAccountId[0] == 0 ? NULL : mAccountId; }
	AccountLevel getAccountLevel() const { return mAccountLevel; }
	bool		setAccountLevel(AccountLevel lv) { mAccountLevel = lv; return true; }
	bool		setDeviceId(const char *id) {
		if( id )
			strcpy(mDeviceId, id);
		else
			mDeviceId[0]	= 0;
		return true;
	}
	const char *getDeviceId() const { return mDeviceId[0] == 0 ? NULL : mDeviceId; }
	bool		setServiceId(const char *id) {
		if( id )
			strcpy(mServiceId,id);
		else
			mServiceId[0] = 0;
		return true;
	}
	const char *getServiceId() const { return mServiceId[0] == 0 ? NULL : mServiceId; }
	bool		setSessionId(const char *id) {
		if( id )
			strcpy(mSessionId, id);
		else
			mSessionId[0] = 0;
		return true;
	}
	const char *getSessionId() const { return mSessionId[0] == 0 ? NULL : mSessionId; }
	int			getDiscriptor() const { return mFd; }
	const sockaddr_in *getPeerAddress(sockaddr_in *addr) const { if( addr ) *addr = mPeerAddr;  return &mPeerAddr; }
	struct event *assignEvent(event_base *base, event_callback_fn fn);

	Task *		getReciveTask();
	Task *		getSendTask() const;
	int			getRunningTaskCount() const;
	void		beginTask(Task *task);
	void		beginReciveTask(Task *task);
	void		beginSendTask(Task *task);
	void		endTask(Task *task);

//	Buffer *	getReadBuffer() { return &mReadBuff; }
//	Buffer *	getWriteBuffer() { return &mWriteBuff; }
	int			getCommandQueueCount() {
		return (int)mCmdQueue.getSize();
	}
	bool		isCommandQueueEmpty() {
		return mCmdQueue.empty();
	}
	QueueNode *	getNextCommand() {
		return (QueueNode*)mCmdQueue.removeTop();
	}
	bool		putNextCommand(QueueNode *q) {
		return mCmdQueue.addBottom((LinkListNode*)q);
	}
	ssize_t		read(char *buff, size_t size);
	ssize_t		unread(char *buff, size_t size);

protected:
	Sentinel *		mSentinel;
	bool			mInUse;
	sockaddr_in 	mPeerAddr;
	int				mFd;
	struct event *	mRecvEvent;
	char			mNonce[24];
	char			mAccountId[SST_ACCOUNTID_LEN+1];
	AccountLevel	mAccountLevel;
	char			mUserId[SST_USERID_LEN+1];
	char			mPasswd[SST_USERID_LEN+1];
	char			mDeviceId[SST_DEVICEID_LEN+1];
	char			mServiceId[SST_SERVICEID_LEN+1];
	char			mSessionId[SST_SESSIONID_LEN+1];
	Task *			mRecvTask;
	Task *			mSendTask;
	int				mTaskCnt;
	SessionStatus	mStatus;
	time_t			mStart;
	time_t			mLastReciveTime;
	LinkList		mCmdQueue;
	LockObject		mLock;
	StdBuffer		mReadBuffer;

	Session *		mPrevList;
	Session *		mNextList;
};

class SessionPool {
public:
	SessionPool();
	~SessionPool();

	void		clear();
	bool		configure(Sentinel *obj, Conf *conf);
	void		freeSession(Session *con);
	Session *	getSession();

	Session *	getUse();
	Session *	getNext(Session *con);
	size_t		getCapacity() const { return nSize; }
	size_t		getActiveSessions() const { return nUse; }
	Session *	findDeviceSession(const char *deviceId);
	Session *	findAcountSession(const char *accountId);

	bool		diag(pjson::builder &jb);

protected:
	Sentinel *	mSentinel;
	LockObject	mLock;
	Session *	mUseList;
	Session *	mFreeList;
	size_t		nSize;
	size_t		nUse;
	size_t		nFree;
};

}

#endif /* SESSION_H_ */
