/*
 * queue.cpp
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#include "queue.h"
#include "task.h"
#include "sentinel.h"
#include <syslog.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

namespace SST {

unsigned long long QueueNode::sIdSeq = 1;

QueueNode::QueueNode(Task *task, Process *proc, int func, int step)
{
	mId			= sIdSeq++;
	mTask		= task;
	mType		= QueueTypeBase;
	mSequence	= 0;
	mWaitFor	= 0;

	mProc		= proc;
	mFunc		= func;
	mStep		= step;

	mMsg		= NULL;
	mJson		= NULL;
}

QueueNode::~QueueNode()
{
	if( mMsg )	delete mMsg;
	if( mJson )	delete mJson;
}

void QueueNode::setMessage(const char *fmt, ... )
{
    va_list ap;
    if( fmt ) {
    	if( mMsg ) delete mMsg;
    	mMsg = new StdBuffer();
        va_start(ap, fmt);
    	mMsg->addvafmt(fmt, ap);
        va_end(ap);
    }
}

void QueueNode::setMessage(const char *fmt, va_list ap)
{
    if( fmt ) {
    	if( mMsg ) delete mMsg;
    	mMsg = new StdBuffer();
    	mMsg->addvafmt(fmt, ap);
    }
}

void QueueNode::setMessage(pjson::builder &jb)
{
   	if( mMsg ) delete mMsg;
   	mMsg = new StdBuffer();

	pjson::json *js = jb.detouch();
	if( !js->getText(mMsg) ) {
		return;
	}
	delete js;
	mMsg->add("\r\n\r\n", 4);
}


//////////////////////////////////////////////////////////////////
void QnResult::setResult(int type, ErrorCode code, const char *fmt, ... )
{
    va_list ap;
    va_start(ap, fmt);
    return setResult(type, code, fmt, ap);
}

void QnResult::setResult(int type, ErrorCode code)
{
	mResultType	= type;
	mResultCode	= code;
	if( mMsg )	delete mMsg;
	if( mJson )	delete mJson;
	mMsg	= NULL;
	mJson	= NULL;
}


void QnResult::setResult(int type, ErrorCode code, const char *fmt, va_list ap)
{
	mResultType	= type;
	mResultCode	= code;
    if( fmt != NULL ) {
    	setMessage(fmt, ap);
    }
}

void QnResult::setResult(int type, ErrorCode code, pjson::json *js)
{
    mResultType	= type;
    mResultCode	= code;
    setJSONMessage(js);
}

void QnResult::setResult(int type, ErrorCode code, const char *buffer, size_t size)
{
    mResultType	= type;
    mResultCode	= code;
	if( mMsg )	delete mMsg;
	if( mJson )	delete mJson;
	mJson	= NULL;
	mMsg = new StdBuffer();
	mMsg->add(buffer, size);
}

void QnResult::addResult(const char *buffer, size_t size)
{
	mMsg->add(buffer, size);
}

//////////////////////////////////////////////////////////////////

Queue::Queue()
{
	mTopId	= 0;
	sem_init(&mQevent, 0, 0);
}

Queue::~Queue()
{
	clear();
}

bool Queue::put(QueueNode *node)
{
	if( empty() )
		mTopId = node->getId();
	if( !addBottom(node) )
		return false;
	sem_post(&mQevent);
	return true;
}

QueueNode * Queue::get()
{
	if( sem_wait(&mQevent) == -1 ) {
		return NULL;
	}
	QueueNode *n = (QueueNode*)LinkList::removeTop();
	{
		READ_LOCK(mLock);
		if( n == NULL || empty() )
			mTopId	= 0;
		else
			mTopId	= next()->getId();
	}
	return n;
}
unsigned long long Queue::getNextId() const
{
	READ_LOCK(const_cast<Queue*>(this)->mLock);
	return mTopId;
}

}



