/*
 * requester.cpp
 *
 *  Created on: 2012/07/31
 *      Author: tanaka
 */

#include "../include/sst_types.h"
#include "message.h"
#include "sentinel.h"
#include "proc_requester.h"
#include <syslog.h>
#include <curl/curl.h>

namespace SST {


QnHTTPRequest::QnHTTPRequest(Task *task) : QueueNode(task)
{
	mType		= QueueHTTPRequest;
	mProc		= &task->getSentinel()->getRequester();
	mFunc		= (int)CMDReqAccess;
	mURL 		= NULL;
	mAuthType	= NULL;
	mRealm		= NULL;
	mUser		= NULL;
	mPass		= NULL;
	mPostParamBuff	= 0;
	mPostParamCount	= 0;
	mPostParamList	= NULL;
	mPostFileData	= NULL;
	mPostFileName	= NULL;
}

QnHTTPRequest::~QnHTTPRequest()
{
	if( mURL ) free(mURL);
	if( mUser ) free(mUser);
	if( mPass ) free(mPass);
	if( mPostFileData ) delete mPostFileData;
	if( mPostFileName ) free(mPostFileName);
	size_t i;
	for( i = 0; i < mPostParamCount; i++ ) {
		if( mPostParamList[i].name )
			free(mPostParamList[i].name);
		if( mPostParamList[i].value )
			free(mPostParamList[i].value);
	}
	if( mPostParamBuff )
		free(mPostParamList);
}

bool QnHTTPRequest::setAccessRequest(const char *url)
{
	if( !url )
		return false;
	mFunc	= CMDReqAccess;
	mURL	= strdup(url);
	return true;
}

bool QnHTTPRequest::setGetRequest(const char *url)
{
	if( !url )
		return false;
	mFunc	= CMDReqGet;
	mURL	= strdup(url);
	return true;
}

bool QnHTTPRequest::setPostRequest(const char *url)
{
	if( !url )
		return false;
	mFunc	= CMDReqPost;
	mURL	= strdup(url);
	return true;
}

bool QnHTTPRequest::setAccount(const char *user, const char *pass)
{
	if( mUser ) free(mUser);
	if( mPass ) free(mPass);
	mUser	= NULL;
	mPass	= NULL;
	if( user ) mUser = strdup(user);
	if( pass ) mPass = strdup(pass);
	return true;
}
bool QnHTTPRequest::setPostParam(const char *name, const char *value)
{
	if( mPostParamCount + 1 > mPostParamBuff ) {
		NV *newList	= (NV*)realloc(mPostParamList, sizeof(NV)*(mPostParamBuff+10));
		if( newList == NULL ) return false;
		for( size_t i = 0; i < 10; i++ ) {
			newList[mPostParamCount+1].name		= NULL;
			newList[mPostParamCount+1].value	= NULL;
		}
		mPostParamList	= newList;
		mPostParamBuff	+= 10;
	}
	if( name != NULL )
		mPostParamList[mPostParamCount].name	= strdup(name);
	else
		mPostParamList[mPostParamCount].name	= NULL;
	if( value != NULL )
		mPostParamList[mPostParamCount].value	= strdup(value);
	else
		mPostParamList[mPostParamCount].value	= NULL;
	mPostParamCount++;
	return true;
}

bool QnHTTPRequest::setPostFile(const char *name, StdBuffer *data)
{
	if( mPostFileData != NULL && mPostFileData != data )
		delete mPostFileData;

	mPostFileData	= data;
	mPostFileName	= strdup(name);
	return true;
}

//////////////////////////////////////////////////////////////////////
QnHTTPResult::QnHTTPResult(Task *task) : QnResult(task)
{
	mType		= QueueHTTPResponse;
	mStatusCode	= 0;
}

QnHTTPResult::~QnHTTPResult()
{
}

//////////////////////////////////////////////////////////////////////
Requester::Requester()
{
}

Requester::~Requester()
{
	clear();
}

bool Requester::configure(Sentinel *obj, Conf *conf)
{
	if( !Process::configure(obj, conf) )
		return false;

	mMaxThread	= conf->maxHTTPProcess;
	mMinThread	= conf->minHTTPProcess;

	return true;
}

void Requester::clear()
{
}


const char *Requester::getFuncName(int id)
{
	switch(id) {
	case CMDReqAccess:	return "ReqAccess";
	case CMDReqGet:		return "ReqGet";
	case CMDReqPost:	return "ReqPost";
	}
	return Process::getFuncName(id);
}

bool Requester::exec(QueueNode *q)
{
	bool r;
	switch(q->getType()) {
	case QueueHTTPRequest:
		switch(q->getFunction()) {
		case CMDReqAccess:	r = cmdHttpAccess((QnHTTPRequest*)q);	break;
		case CMDReqGet:		r = cmdHttpGet((QnHTTPRequest*)q);		break;
		case CMDReqPost:	r = cmdHttpPost((QnHTTPRequest*)q);		break;
		default:
			taskLog(q, LOG_ERR, "%s::exec: unknown query type. q=%x type=%d query=%d", getName(), q, q->getType(), q->getFunction());
			r = false;
			break;
		}
		break;
	default:
	 	taskLog(q, LOG_INFO, "%s::exec: unknown queue type. q=%x type=%d.", getName(), q, q->getType());
	 	r	= false;
	 	break;
	}
	return r;
}

bool Requester::cmdHttpAccess(QnHTTPRequest *q)
{
	CURL *curl;
	CURLcode res;

	taskLog(q, LOG_DEBUG, "ACCESS URL=%s", q->mURL);

	curl = curl_easy_init();
	if( !curl) {
		return taskResponse(q, ErrorRuntime, "%s. CURL init failed.", codeToMessgae(ErrorRuntime));
	}
	Task *task = q->getTask();

	QnHTTPResult *r =  new QnHTTPResult(task);
	cbdata cb;
	cb.pThis	= this;
	cb.pQueue	= q;
	cb.pResult	= r;

	curl_easy_setopt(curl, CURLOPT_URL, q->mURL);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 1);
//	curl_easy_setopt(curl, CURLOPT_HEADER, 1);

	char uspw[256];
	if( /*qn->mAuthType && */ q->mUser && q->mPass ) {
		sprintf(uspw, "%s:%s", q->mUser, q->mPass);
		curl_easy_setopt(curl, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
		curl_easy_setopt(curl, CURLOPT_USERPWD, uspw);
		taskLog(q, LOG_DEBUG, "Requester::exec: auth=%s user=%s password=%s", uspw, q->mUser, q->mPass);
	}
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, pxWriteCB);
	curl_easy_setopt(curl, CURLOPT_WRITEDATA, &cb);
	curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, pxHeaderCB);
	curl_easy_setopt(curl, CURLOPT_HEADERDATA, &cb);
	res = curl_easy_perform(curl);
	long statusCode;
	curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &statusCode);
	curl_easy_cleanup(curl);

	if (res != CURLE_OK) {
		delete r;
		return taskResponse(q, ErrorRuntime, "%s. CURL request failed. code=%d", codeToMessgae(ErrorRuntime), res);
	}

	r->setResult(q->getFunction(), ErrorOk);
	r->mStatusCode = statusCode;
	taskLog(q, LOG_DEBUG, "Requester process end" );
	return task->endTask(r);
}

bool Requester::cmdHttpGet(QnHTTPRequest *q)
{
	Task *task = q->getTask();

	CURL *curl;
	CURLcode res;

	taskLog(q, LOG_DEBUG, "GET URL=%s", q->mURL);

	curl = curl_easy_init();
	if( !curl) {
		return taskResponse(q, ErrorRuntime, "%s. CURL init failed.", codeToMessgae(ErrorRuntime));
	}

	QnHTTPResult *r =  new QnHTTPResult(task);
	cbdata cb;
	cb.pThis	= this;
	cb.pQueue	= q;
	cb.pResult	= r;

	curl_easy_setopt(curl, CURLOPT_URL, q->mURL);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 1);
//	curl_easy_setopt(curl, CURLOPT_HEADER, 1);

	StdBuffer uspw;
	if( q->mUser && q->mPass ) {
		uspw.addfmt("%s:%s", q->mUser, q->mPass);
		curl_easy_setopt(curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_easy_setopt(curl, CURLOPT_USERPWD, uspw.getPtr());
	}
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, pxWriteCB);
	curl_easy_setopt(curl, CURLOPT_WRITEDATA, &cb);
	curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, pxHeaderCB);
	curl_easy_setopt(curl, CURLOPT_HEADERDATA, &cb);
	res = curl_easy_perform(curl);
	long statusCode = 0;
	curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &statusCode);
	curl_easy_cleanup(curl);

	if (res != CURLE_OK) {
		delete r;
		return taskResponse(q, ErrorRuntime, "%s. CURL request failed. code=%d", codeToMessgae(ErrorRuntime), res);
	}
	r->setReqResult(ErrorOk, statusCode, "Ok");
	return task->endTask(r);
}

bool Requester::cmdHttpPost(QnHTTPRequest *q)
{
	Task *task = q->getTask();
	CURL *curl;
	CURLcode res;
	long statusCode = 200;

	taskLog(q, LOG_DEBUG, "POST URL=%s", q->mURL);
	QnHTTPResult *r =  new QnHTTPResult(task);

	curl = curl_easy_init();
	if( !curl) {
		return taskResponse(q, ErrorRuntime, "%s. CURL init failed.", codeToMessgae(ErrorRuntime));
	}

	cbdata cb;
	cb.pThis	= this;
	cb.pQueue	= q;
	cb.pResult	= r;

	curl_easy_setopt(curl, CURLOPT_URL, q->mURL);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 1);

	StdBuffer uspw;
	if( q->mUser && q->mPass ) {
		uspw.addfmt("%s:%s", q->mUser, q->mPass);
		curl_easy_setopt(curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_easy_setopt(curl, CURLOPT_USERPWD, uspw.getPtr());
	}
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, pxWriteCB);
	curl_easy_setopt(curl, CURLOPT_WRITEDATA, &cb);
	curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, pxHeaderCB);
	curl_easy_setopt(curl, CURLOPT_HEADERDATA, &cb);

    struct curl_httppost* firstform = NULL;
    struct curl_httppost* lastform = NULL;
	for( size_t i = 0; i < q->mPostParamCount; i++ ) {
		curl_formadd(&firstform,  &lastform,
				CURLFORM_COPYNAME, q->mPostParamList[i].name,
				CURLFORM_COPYCONTENTS, q->mPostParamList[i].value,
				CURLFORM_END);
	}
	if( q->mPostFileData != NULL ) {
		curl_formadd(&firstform,  &lastform,
				CURLFORM_CONTENTTYPE, "multipart/form-data",
				CURLFORM_COPYNAME, "data",
				CURLFORM_BUFFER, q->mPostFileName,
				CURLFORM_BUFFERPTR, q->mPostFileData->getPtr(),
				CURLFORM_BUFFERLENGTH, q->mPostFileData->size(),
				CURLFORM_END);
	}

	curl_easy_setopt(curl, CURLOPT_HTTPPOST, firstform);
	res = curl_easy_perform(curl);
	curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &statusCode);
	curl_easy_cleanup(curl);
	curl_formfree(firstform);

	if (res != CURLE_OK) {
		delete r;
		return taskResponse(q, ErrorRuntime, "%s. CURL request failed. code=%d", codeToMessgae(ErrorRuntime), res);
	}

	r->setReqResult(ErrorOk, statusCode, "Ok");
	return task->endTask(r);
}

void Requester::stop(QueueNode *q)
{
	// TODO: スレッド停止処理
	//	doCancel	= true;
}

size_t Requester::pxHeaderCB(char* ptr, size_t size, size_t nmemb, void* data)
{
	// TODO: HTTP ヘッダの受け取り
	cbdata *cb = (cbdata*)data;
	QnHTTPResult *r = cb->pResult;
    int block = size * nmemb;
    r->mHeader.add(ptr, block);
	cb->pThis->taskLog(cb->pQueue, LOG_DEBUG, "Requester::pxHeaderCB: %s", ptr);
    return block;
}

size_t Requester::pxWriteCB(char* ptr, size_t size, size_t nmemb, void* data)
{
	cbdata *cb = (cbdata*)data;
	QnHTTPResult *r = cb->pResult;
	r->mBody.add(ptr, size*nmemb);
	return size * nmemb;
}

#if 0
size_t Requester::writeCB(char* ptr, size_t size, size_t nmemb, Task *task)
{
	taskLog(q, LOG_DEBUG, "RequestProcessor::writeCB ptr=%x size=%u, nmemb=%u", ptr, size, nmemb);
	// TODO: レスポンスをTask内に格納する
	task->addResponse(ptr, size*nmemb);
	/*
	if( response == NULL ) {
		response = new Message();
	}
	response->addContent(ptr, size*nmemb);
	QnResponse *n = new QnResponse(curNode->con, response, curNode->data);
	requester->sentinel->getQueue().put(n);
	*/
    return size * nmemb;
}
#endif


}


