/*
 * listner.h
 *
 *  Created on: 2012/07/04
 *      Author: Yasuoki
 */

#ifndef LISTNER_H_
#define LISTNER_H_

#include "../include/sst_types.h"
#include "process.h"
#include "pjson.h"
#include <event2/event.h>

namespace SST {

enum ListenerCommand {
	CMDComNull			= 0,
	CMDComListen		= 1,
	CMDComAccept		= 2,
	CMDComRecive		= 3,
	CMDComResponse		= 4,
	CMDComSend			= 5,
	CMDComPurge			= 6,
	CMDComRecvRaw		= 7,
};

class QueueCommSend : public QueueNode
{
private:
	QueueCommSend(const QueueCommSend &d);
public:
	QueueCommSend(Task *task, Session *session);
	virtual ~QueueCommSend();

	Session *		mSession;
};

class QueueCommRecvRaw : public QueueNode
{
private:
	QueueCommRecvRaw(const QueueCommRecvRaw &d);
public:
	QueueCommRecvRaw(Task *task, size_t size);
	virtual ~QueueCommRecvRaw();

	size_t		mSize;
};

class QnCommRecvResult : public QnResult
{
private:
	QnCommRecvResult(const QnCommRecvResult &d);
public:
	QnCommRecvResult(Task *task);
	~QnCommRecvResult();

	void setResult(ErrorCode code, const char *fmt, ... ) {
	    va_list ap;
	    va_start(ap, fmt);
	    QnResult::setResult(CMDComRecvRaw, code, fmt, ap);
	}
	void setResult(StdBuffer *buff) {
	    QnResult::setResult(CMDComRecvRaw, ErrorOk);
		mData	= buff;
	}

	StdBuffer *	mData;
};

class Listener : public Process {
public:
	Listener();
	~Listener();

	virtual bool	configure(Sentinel *obj, Conf *conf);
	virtual void	clear();
	virtual const char *getName() const { return "Listener"; }
	virtual const char *getFuncName(int id);
	bool 			waitData(Session *con);

	virtual bool	taskResponseLogVa(int logLevel, QueueNode *q, ErrorCode code, const char *fmt, va_list ap);

protected:
	virtual bool	exec(QueueNode *q);
	virtual void	stop(QueueNode *q);

	static void		connectCB(int fd, short event, void *args);
	static void		reciveCB(int fd, short event, void *args);

	void	connectProc(int fd, short event);
	void	reciveProc(Session *conn, short event);
	bool	parseRequest(QueueNode *q, Buffer *buff );

	bool  	response(QueueNode *q, pjson::json *js);
	bool	makeResponseMessage(QueueNode *q, Buffer *buff);

	bool	cmdListen(QueueNode *q);
	bool	cmdAccept(QueueNode *q);
	bool	cmdRecive(QueueNode *q);
	bool	cmdResponse(QueueNode *q);
	bool	cmdSend(QueueNode *q);
	bool	cmdPurge(QueueNode *q);
	bool	cmdRecvRaw(QueueNode *q);

	int				sFd;
	event_base *	sListenBase;
	event	*		sListenEvent;
	LockObject		mLock;

};

}

#endif /* LISTNER_H_ */
