/*
 * main.cpp
 *
 *  Created on: 2012/06/12
 *      Author: yasuoki
 */

#include "sentinel.h"
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

using namespace SST;

int main(int argc, char *argv[])
{
	char confFile[1024];

	strcpy(confFile, /*SST_CONFFOLDER "/"*/ SST_CONFFILE);

	openlog(SST_SYSLOGIDENT, LOG_PID, LOG_USER);
	Sentinel *obj = new Sentinel();

	obj->log(LOG_NOTICE, "sentinel %s", SST_VERSION);

	argc--; argv++;
	while(argc) {
		char *p = *argv;
		if( *p == '-' ) {
			if( strcmp( p+1, "f") == 0 ) {
				argc--; argv++;
				if( !argc ) {
					obj->log(LOG_ERR, "param error (-f)");
					exit(EXIT_FAILURE);
				}
				strcpy(confFile, *argv );
				argc--; argv++;
			}
			continue;
		}
		obj->log(LOG_ERR, "param error (%s)", p);
		exit(EXIT_FAILURE);
	}

	if( !obj->loadConfig(confFile) ) {
		exit(EXIT_FAILURE);
		closelog();
	}

	Conf *conf = obj->getConf();
	if( (conf->logIdent && strcmp(conf->logIdent, SST_SYSLOGIDENT) != 0) || conf->daemonaize ) {
		closelog();
		openlog(conf->logIdent, LOG_PID, LOG_DAEMON);
		obj->log(LOG_NOTICE, "sentinel %s", SST_VERSION);
	}

	if( conf->daemonaize ) {
		pid_t pid, sid;
		pid = fork();
		if (pid < 0) {
			obj->log(LOG_ERR, "fork");
			exit(EXIT_FAILURE);
		}
		if (pid > 0)
			exit(EXIT_SUCCESS);

		sid = setsid();
		if (sid < 0) {
			obj->log(LOG_ERR, "setsid");
			exit(EXIT_FAILURE);
		}
		if (chdir("/") < 0) {
			obj->log(LOG_ERR, "chdir");
			exit(EXIT_FAILURE);
		}
		umask(0);
		close(STDIN_FILENO);
		close(STDOUT_FILENO);
		close(STDERR_FILENO);
	}

	if( !obj->run() ) {
		obj->log(LOG_ERR, "sentinel aborted");
		exit(EXIT_FAILURE);
	}


#if 0
	BZMPD *bzmpdPtr = new BZMPD();
	if (!bzmpdPtr->loadConf(confFile)) {
		syslog(LOG_ERR, "bzmpd abort");
		exit(EXIT_FAILURE);
	}
#endif
#if 0
	REGIONLIST *pList = bzmpdPtr->getRegionList();
	if( pList ) {
		int i;
		for( i = 0; i < pList->nRegions; i++) {
			syslog(LOG_INFO, "=== %d:%s ===", pList->pRegions[i].id, pList->pRegions[i].regionName);
			STATIONLIST *pFM = bzmpdPtr->getFMStationLList(pList->pRegions[i].id);
			if( pFM ) dumpStations(bzmpdPtr, pFM, "■");
			STATIONLIST *pCFM = bzmpdPtr->getCFMStationLList(pList->pRegions[i].id);
			if( pCFM ) dumpStations(bzmpdPtr, pCFM, "◇");
		}
		bzmpdPtr->freeRegionList(pList);
	}
#endif
#if 0
	if (!bzmpdPtr->mainLoop()) {
		syslog(LOG_ERR, "bzmpd abort");
		exit(EXIT_FAILURE);
	}
	bzmpdPtr->destroy();
#endif
	closelog();
	exit(EXIT_SUCCESS);
}

