/*
 * cmd_update.cpp
 *
 *  Created on: 2013/03/28
 *      Author: yasuoki
 */

#include "commands.h"
#include "proc_command.h"
#include "proc_database.h"
#include "proc_requester.h"
#include "proc_listener.h"
#include "task.h"
#include "sentinel.h"
#include "buffer.h"
#include "pjson.h"
#include <syslog.h>
#include <errno.h>
#include <netdb.h>
#include <assert.h>

namespace SST {


class TBUpdate: public TaskBuffer {
public:
	TBUpdate() {
		mJsCommand	= NULL;
		mJsResource	= NULL;
		mJsSID		= NULL;
		mJsSName	= NULL;
		mJsRID		= NULL;
		mJsRName	= NULL;
		mJsRef		= NULL;
		mJsDefMode	= NULL;
		mJsMode		= NULL;
		mService	= NULL;
		mList		= NULL;
		mAllUpdate	= false;
		mDefMode	= QnCommSync::SyncModeAdd;
		mReq		= 0;
		mProc		= 0;
		mUpdate		= 0;
	}
	virtual ~TBUpdate() {
		if( mJsCommand )	delete mJsCommand;
		if( mService ) 		free(mService);
		if( mList )			free(mList);
	}
	pjson::json *	mJsCommand;
	pjson::value *	mJsSID;
	pjson::value *	mJsSName;
	pjson::value *	mJsResource;
	pjson::value *	mJsRID;
	pjson::value *	mJsRName;
	pjson::value *	mJsRef;
	pjson::value *	mJsDefMode;
	pjson::value *	mJsMode;

	ResultService *	mService;
	bool			mAllUpdate;
	QnCommSync::SyncMode mDefMode;
	size_t 			mReq;
	size_t 			mProc;
	size_t 			mUpdate;

	ResultList *	mList;
};

bool CommandProc::cmdUpdate(QueueNode *q)
{
	Task *task = q->getTask();
	int step	= q->getStep();

	TBUpdate *tb = (TBUpdate *)task->getTaskBuffer();
	if( tb == NULL ) {
		tb = new TBUpdate();
		if( tb == NULL ) {
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
		if( !task->setTaskBuffer(tb) ) {
			delete tb;
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
 	}

	switch(step) {
	case 0:
		{
			tb->mJsCommand = q->detouchJSONMessage();
			pjson::value *vUpdate = tb->mJsCommand->get("update");
			if( vUpdate ) {
				if( vUpdate->vt != pjson::vt_object ) {
					return taskResponse(q, ErrorParameter, "parameter error");
				}
				tb->mJsSID		= tb->mJsCommand->get("sid",  vUpdate);
				tb->mJsSName	= tb->mJsCommand->get("serviceName",  vUpdate);
				tb->mJsResource	= tb->mJsCommand->get("resource", vUpdate);
				tb->mJsDefMode	= tb->mJsCommand->get("mode", vUpdate);

				if( tb->mJsSID && tb->mJsSID->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"sid\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsSName && tb->mJsSName->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"serviceName\" type.", codeToMessgae(ErrorParameter));
				}

				if( tb->mJsResource ) {
					if( tb->mJsResource->vt == pjson::vt_array ) {
						tb->mUpdate	= pjson::getArraySize(tb->mJsResource);
					} else if( tb->mJsResource->vt == pjson::vt_object ) {
						tb->mUpdate = 1;
					} else {
						return taskResponse(q, ErrorParameter, "%s. \"resource\" type.", codeToMessgae(ErrorParameter));
					}
				} else {
					tb->mAllUpdate = true;
				}
				if( tb->mJsDefMode ) {
					if( tb->mJsDefMode->vt != pjson::vt_string ) {
						return taskResponse(q, ErrorParameter, "%s. \"mode\" type.", codeToMessgae(ErrorParameter));
					}
					if( strcmp(tb->mJsDefMode->vString, "add") == 0 ) {
						if( tb->mAllUpdate ) {
							return taskResponse(q, ErrorParameter, "%s. \"mode\" value.", codeToMessgae(ErrorParameter));
						}
						tb->mDefMode = QnCommSync::SyncModeAdd;
					} else if( strcmp(tb->mJsDefMode->vString, "update") == 0 ) {
						tb->mDefMode = QnCommSync::SyncModeUpdate;
					} else if( strcmp(tb->mJsDefMode->vString, "remove") == 0 ) {
						tb->mDefMode = QnCommSync::SyncModeRemove;
					} else {
						return taskResponse(q, ErrorParameter, "%s. \"mode\" value.", codeToMessgae(ErrorParameter));
					}
				}

				size_t i;
				for( i = 0; i < tb->mUpdate; i++ ) {
					pjson::value *v;
					if( tb->mJsResource->vt == pjson::vt_object) {
						v	= tb->mJsResource;
					} else if( i < tb->mUpdate ){
						v	= pjson::getArrayContent(tb->mJsResource, i);
					} else {
						break;
					}
					tb->mJsRID		= tb->mJsCommand->get("rid",  v);
					tb->mJsRName	= tb->mJsCommand->get("resourceName",  v);
					tb->mJsRef		= tb->mJsCommand->get("ref",  v);
					tb->mJsMode		= tb->mJsCommand->get("mode",  v);

					if( tb->mJsRID && tb->mJsRID->vt != pjson::vt_string ) {
						return taskResponse(q, ErrorParameter, "%s. \"resource[%d].rid\" type.", codeToMessgae(ErrorParameter), i);
					}
					if( tb->mJsRName && tb->mJsRName->vt != pjson::vt_string ) {
						return taskResponse(q, ErrorParameter, "%s. \"resource[%d].resourceName\" type.", codeToMessgae(ErrorParameter), i);
					}
					if( tb->mJsRef && tb->mJsRef->vt != pjson::vt_string ) {
						return taskResponse(q, ErrorParameter, "%s. \"resource[%d].ref\" type.", codeToMessgae(ErrorParameter), i);
					}
					if( tb->mJsMode && tb->mJsMode->vt != pjson::vt_string ) {
						return taskResponse(q, ErrorParameter, "%s. \"resource[%d].mode\" type.", codeToMessgae(ErrorParameter), i);
					}
					QnCommSync::SyncMode	mode = tb->mDefMode;
					if( tb->mJsMode ) {
						if( strcmp(tb->mJsDefMode->vString, "add") == 0 ) {
							mode	= QnCommSync::SyncModeAdd;
						} else if( strcmp(tb->mJsDefMode->vString, "update") == 0 ) {
							mode	 = QnCommSync::SyncModeUpdate;
						} else if( strcmp(tb->mJsDefMode->vString, "remove") == 0 ) {
							mode	= QnCommSync::SyncModeRemove;
						} else {
							return taskResponse(q, ErrorParameter, "%s. \"resource[%d].mode\" value.", codeToMessgae(ErrorParameter), i);
						}
						if( mode == QnCommSync::SyncModeAdd ) {
							if( tb->mJsRID ) {
								return taskResponse(q, ErrorParameter, "%s. \"resource[%d].rid\" is specified against addition mode.", codeToMessgae(ErrorParameter), i);
							}
							if( tb->mJsRName ) {
								return taskResponse(q, ErrorParameter, "%s. \"resource[%d].resourceName\" is specified against addition mode.",codeToMessgae(ErrorParameter), i);
							}
							if( tb->mJsRef == NULL ) {
								return taskResponse(q, ErrorParameter, "%s. \"resource[%d].ref\" is not specified against addition mode.",codeToMessgae(ErrorParameter), i);
							}
						} else if( mode == QnCommSync::SyncModeUpdate ) {
							if( !tb->mJsRID && !tb->mJsRName ) {
								return taskResponse(q, ErrorParameter, "%s. \"resource[%d]\" resource is not specified against updating mode.",codeToMessgae(ErrorParameter), i);
							}
						} else if( mode == QnCommSync::SyncModeRemove ) {
							if( !tb->mJsRID && !tb->mJsRName ) {
								return taskResponse(q, ErrorParameter, "%s. \"resource[%d]\" resource is not specified against remove mode.",codeToMessgae(ErrorParameter), i);
							}
							if( tb->mJsRef ) {
								return taskResponse(q, ErrorParameter, "%s. \"resource[%d].ref\" is specified against remove mode.",codeToMessgae(ErrorParameter), i);
							}
						}
					}
					if( tb->mJsRID == NULL && tb->mJsRName == NULL && tb->mJsRef == NULL ) {
						return taskResponse(q, ErrorParameter, "%s. \"resource[%d]\" not specified", codeToMessgae(ErrorParameter), i);
					}
					tb->mReq++;
				}
			} else {
				tb->mAllUpdate	= true;
				tb->mDefMode	= QnCommSync::SyncModeUpdate;
			}

			QueryKeyType sref;
			sref.mId	= tb->mJsSID ? tb->mJsSID->vString : NULL;
			sref.mName	= tb->mJsSName ? tb->mJsSName->vString : NULL;
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryService(&sref);
			return task->call(qn, step+1);
		}
		break;
	case 1:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "Service info load failed. %s", res->getMessagePtr());
			}
			tb->mService	= (ResultService*)(res->mResult);
			res->mResult	= NULL;

			// TODO: permission check

			if( tb->mAllUpdate ) {
				QueryKeyType	sref;
				sref.mId	= tb->mJsSID ? tb->mJsSID->vString : NULL;
				sref.mName	= tb->mJsSName ? tb->mJsSName->vString : NULL;
				QnDBQuery *qn = new QnDBQuery(task);
				qn->queryResourceList(&sref, NULL);
				return task->call(qn, step+1);
			}
		}
	case 2:
		{
			if( step == 2 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode code	= res->getResultCode();
				if( code != ErrorOk ) {
					return taskResponse(q, code, "Resource list load failed. %s", res->getMessagePtr());
				}
				tb->mList		= (ResultList*)(res->mResult);
				res->mResult	= NULL;
				tb->mUpdate		= tb->mList->mList.values;
			}

			size_t i;
			for( i = 0; i < tb->mUpdate; i++ ) {
				const char * vRID	= NULL;
				const char * vRName	= NULL;
				const char * vRef	= NULL;
				QnCommSync::SyncMode	mode;
				if( tb->mAllUpdate ) {
					vRID	= tb->mList->mList.value[i];
					mode	= tb->mDefMode;
				} else {
					pjson::value *v;
					if( tb->mJsResource->vt == pjson::vt_object) {
						v	= tb->mJsResource;
					} else if( i < tb->mUpdate ){
						v	= pjson::getArrayContent(tb->mJsResource, i);
					} else {
						break;
					}
					tb->mJsRID		= tb->mJsCommand->get("rid",  v);
					tb->mJsRName	= tb->mJsCommand->get("resourceName",  v);
					tb->mJsRef		= tb->mJsCommand->get("ref",  v);
					tb->mJsMode		= tb->mJsCommand->get("mode",  v);
					vRID	= tb->mJsRID ? tb->mJsRID->vString : NULL;
					vRName	= tb->mJsRName ? tb->mJsRName->vString : NULL;
					vRef	= tb->mJsRef ? tb->mJsRef->vString : NULL;
					mode	= tb->mDefMode;
					const char *vMode	= tb->mJsMode ? tb->mJsMode->vString : NULL;
					if( vMode ) {
						if( strcmp(vMode, "add") == 0 )
							mode = QnCommSync::SyncModeAdd;
						else if( strcmp(vMode, "update") == 0 )
							mode = QnCommSync::SyncModeUpdate;
						else if( strcmp(vMode, "remove") == 0 )
							mode = QnCommSync::SyncModeRemove;
					}
				}

				Task *st = mSentinel->getTaskManager().createTaskFromBaseTask(task);
				QnCommSync *qn = new QnCommSync(st);
				QueryKeyType rref;
				rref.mId	= vRID;
				rref.mName	= vRName;
				qn->setSync(&tb->mService->mService, &rref, vRef, mode);
				taskLog(q, LOG_DEBUG, "new task task=%d q=%lld serviceId=%s rid=%s rname=%s URL=%s",
						st->getTaskId(), qn->getId(),
						st->getServiceId(),
						rref.mId ? rref.mId : "(not set)",
						rref.mName ? rref.mName : "(not set)",
						qn->mData->mRef);
				st->startTask(qn);
				tb->mProc++;
			}

			pjson::builder jb;
			if( !jb.init(256) ||
				!jb.beginObject() ||
				!jb.addObjectProp("result", 6) ||
				!jb.valueInt(0) ||
				!jb.addObjectProp("sequence", 8) ||
				!jb.valueInt(task->getSequence()) ||
				!jb.addObjectProp("requested", 9) ||
				!jb.valueInt(tb->mReq) ||
				!jb.addObjectProp("processed", 9) ||
				!jb.valueInt(tb->mProc) ||
				!jb.endObject() ) {
				taskLog(q, LOG_ERR, "%s::cmdUpdate: json builder failed code=%d", getName(), jb.getError());
				return false;
			}
			return response(q,jb);
		}
	}
	taskLog(q, LOG_ERR, "unknown step=%d.", step);
	return false;
}

}

