<?php
define(LOGFILE, 'upload.log');

function get_resource($r) {
	$ret = <<<END
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
resource $r
END;
	return $ret;
}

function get_gadget($r, $g) {
	$ret = <<<END
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
resource $r gadget $g
END;
	return $ret;
}

function get_info($r) {
	$enc = json_encode("update-".$r,JSON_UNESCAPED_UNICODE);
	$js = <<<ENDJSON
{
	"resource":{
		"name":$enc,
		"date":"2013/01/30-20:00:05",
		"tag":"pal",
		"gadget": [
			{
				"name":"image",
				"date":"2013/01/30-20:00:06",
				"tag":"img,jpeg"
			}
		]
	}
}
ENDJSON;
	return $js;
}

function get_shareinfo($r) {
	$groupName = "group" . ($r % 3 +1);
	$enc = json_encode($groupName);
	$js = <<<ENDJSON
{
	"shareInfo":[
		{
			"shareMode":"index",
			"groups":[
				{ "groupName":"group1" },
				{ "groupName":"group2" }
			],
			"permission":{
				"gpsGrace": 3000,
				"offlineGrace": 3000,
				"expire": "2013/04/30-19:00:00",
				"geoLocation": [
					{
						"dis":200,
						"lat":35.684629,
						"lon":139.627888
					},{
						"dis":200,
						"lat":35.455677,
						"lon":140.467893
					}
				],
				"time":{
					"from":"2013/1/1-00:00:00",
					"to":"2013/4/25-23:59:59"
				}
			}
		},
		{
			"shareMode":"full",
			"groups":[
				{ "groupName":"group3" }
			],
			"permission":{
				"access":"write,tag,gadget",
				"gpsGrace": 3000,
				"offlineGrace": 3000,
				"expire": "2013/04/30-19:00:00",
				"geoLocation": [
					{
						"dis":200,
						"lat":35.684629,
						"lon":139.627888
					},{
						"dis":200,
						"lat":35.455677,
						"lon":140.467893
					}
				],
				"time":{
					"from":"2013/1/1-00:00:00",
					"to":"2013/4/25-23:59:59"
				}
			}
		}
	]
}
ENDJSON;
	return $js;
}

function put_gadget($r) {
	$res = $_POST['put_gadget'];
	$aid = $_POST['accountId'];
	$uid = $_POST['userId'];
	$udid= $_POST['udid'];
	$rid = $_POST['resourceId'];
	$rname=$_POST['resourceName'];
	$gname=$_POST['gadgetName'];
	$tag  =$_POST['tag'];
	$ref  =$_POST['date'];
	$size =$_POST['dataSize'];
	$upfile="";
	if (is_uploaded_file($_FILES["upfile"]["tmp_name"])) {
		$upfile = $_FILES["upfile"]["name"];
		if (move_uploaded_file($_FILES["upfile"]["tmp_name"], "files/" . $upfile)) {
			chmod("files/" . $upfile, 0644);
		}
	}

	$line = "$res,$aid,$uid,$udid,$rid,$rname,$gname,$tag,$ref,$size,$upfile";
	$fp = fopen(LOGFILE, "a");
	flock($fp, 2);
	fputs($fp, $line);
	fclose($fp);

	$js = <<<ENDJSON
{
	"result":0
}
ENDJSON;
	return $js;
}

function put_resource($r) {

	$res = $_POST['put_resource'];
	$aid = $_POST['accountId'];
	$uid = $_POST['userId'];
	$udid= $_POST['udid'];
	$rid = $_POST['resourceId'];
	$rname=$_POST['resourceName'];
	$tag  =$_POST['tag'];
	$ref  =$_POST['date'];
	$size =$_POST['dataSize'];
	$upfile="";
	if (is_uploaded_file($_FILES["upfile"]["tmp_name"])) {
		$upfile = $_FILES["upfile"]["name"];
		if (move_uploaded_file($_FILES["upfile"]["tmp_name"], "files/" . $upfile)) {
			chmod("files/" . $upfile, 0644);
		}
	}
	$line = "$res,$aid,$uid,$udid,$rid,$rname,$gname,$tag,$ref,$size,$upfile";
	$fp = fopen(LOGFILE, "a");
	flock($fp, 2);
	fputs($fp, $line);
	fclose($fp);

	$js = <<<ENDJSON
{
	"result":0
}
ENDJSON;
	return $js;
}


function opt_unknown($r) {
	$e = json_encode($r);
	$js = <<<ENDJSON
{
	"error":{
		"msg":"$r"
	}
}
ENDJSON;
	return $js;
}

$me  = $_SERVER["SCRIPT_NAME"];
$url = $_SERVER["PHP_SELF"];
$vp  = substr($url,strlen($me));
$pm  = preg_split("[/]", $vp, 0, PREG_SPLIT_NO_EMPTY);
$pm_cnt = count($pm);
if( $pm_cnt < 2 ) {
	echo opt_unknown("parameter is not specifed");
	exit();
}
$res = $pm[0];
$opt = $pm[1];

if( $opt == 'info' ) {
	echo get_info($res);
} else if( $opt == 'share_info' ) {
	echo get_shareinfo($res);
} else if( $opt == 'get_resource' ) {
	echo get_resource($res);
} else if( $opt == 'put_gadget' ) {
	echo put_gadget($res);
} else if( $opt == 'put_resource' ) {
	echo put_resource($res);
} else {
	$gad = substr($opt, 0, 11);
	if( $gad == 'get_gadget_' ) {
		echo get_gadget($res, substr($opt, 11));
	} else { 
		echo opt_unknown("unknown option \"".$opt."\"");
	}
}
?>
