/*
 * lock.h
 *
 *  Created on: 2012/03/05
 *      Author: yasuoki
 */

#ifndef LOCK_H_
#define LOCK_H_

#include <pthread.h>
#include "../include/sst_types.h"

// #define _LOCK_DEBUG

namespace SST {

#ifdef _DEBUG
#ifndef _CYGWIN
#define USE_TIMEOUT
#endif
#endif


#ifdef _DEBUG
#	define READ_LOCK(L) ReadLock _loc_(L,__FILE__,__LINE__)
#	define WRITE_LOCK(L) WriteLock _loc_(L,__FILE__,__LINE__)
#else
#	define READ_LOCK(L) ReadLock _loc_(L)
#	define WRITE_LOCK(L) WriteLock _loc_(L)
#endif

class LockObject {
public:
	LockObject();
	~LockObject();
	void readLock(
#ifdef _DEBUG
			 const char *f, int l
#endif
			);
	void writeLock(
#ifdef _DEBUG
			 const char *f, int l
#endif
			);
	void unlock();
protected:
	// non copy
	LockObject(const LockObject &);
	LockObject &operator=(const LockObject &);
	pthread_rwlock_t rwlock;
#ifdef _DEBUG
	size_t		_xReadLockCnt;
	pthread_t	_xWriteLockThread;
	bool		_xWriteLocked;
	const char *_xLastLockSrc;
	int			_xLastLockLine;
#endif
};

class LockBase {
public:
	LockBase(LockObject &lc) : lock(lc) {}
	virtual ~LockBase() { lock.unlock(); }

private:
	// non copy
	LockBase(const LockBase &);
	LockBase &operator=(const LockBase &);

protected:
	LockObject &lock;
};

class ReadLock : public LockBase {
public:
#ifdef _DEBUG
	ReadLock(LockObject &lc, const char *f, int l) : LockBase(lc) {
		lc.readLock(f,l);
	}
#else
	ReadLock(LockObject &lc) : LockBase(lc) {
		lc.readLock();
	}
#endif
	virtual ~ReadLock() {}
};
class WriteLock : public LockBase {
public:
#ifdef _DEBUG
	WriteLock(LockObject &lc, const char *f, int l) : LockBase(lc) {
		lc.writeLock(f,l);
	}
#else
	WriteLock(LockObject &lc) : LockBase(lc) {
		lc.writeLock();
	}
#endif
	virtual ~WriteLock() {}
};

}

#endif /* LOCK_H_ */
