/*
 * device_slot.cpp
 *
 *  Created on: 2012/06/15
 *      Author: yasuoki
 */

#include "sentinel.h"
#include "device_slot.h"
#include <malloc.h>
#include <memory.h>

namespace SST {

DeviceSlotList::DeviceSlotList()
{
	mSlots		= 0;
	mAllocs		= 0;
	mSlotList	= NULL;
}

DeviceSlotList::~DeviceSlotList()
{
	clear();
}

bool  DeviceSlotList::configure(Sentinel *obj, Conf *conf)
{
	mSentinel	= obj;
	if( !allocSlot(conf->maxDevices) ) {
		return false;
	}
	return true;
}

bool DeviceSlotList::allocSlot(size_t size)
{
	if( size > mAllocs ) {
		DeviceSlot **list = (DeviceSlot**)realloc(mSlotList, sizeof(DeviceSlot*));
		if( list == NULL ) {
			mSentinel->log(LOG_ERR, "Out of memory at device slot allocate");
			return false;
		}
		memset(list, 0, sizeof(DeviceSlot*));
		mSlotList	= list;
		mAllocs		= size;
	}
	return true;
}

void DeviceSlotList::clear()
{
	if( mAllocs ) {
		free((void*)mSlotList);
	}
	mAllocs		= 0;
	mSlots		= 0;
	mSlotList	= NULL;
}

size_t DeviceSlotList::getSlotCount()
{
	return mSlots;
}

}


