/*
 * commands.h
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#ifndef COMMANDS_H_
#define COMMANDS_H_

#include "../include/sst_types.h"
#include <event2/event.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <memory.h>

namespace SST {

enum Command {
	CMDNull			= 0,
	CMDExit			= 1,

	CMDTypeSession	= 10,
	CMDLogin		= CMDTypeSession+1,

	CMDTypeAccount	= 20,
	CMDRegAccount	= CMDTypeAccount + 1,
	CMDSetAccount	= CMDTypeAccount + 2,
	CMDRmAccount	= CMDTypeAccount + 3,
	CMDLsAccount	= CMDTypeAccount + 4,
	CMDShowAccount	= CMDTypeAccount + 5,
	CMDLockAccount	= CMDTypeAccount + 6,
	CMDUnlockAccount= CMDTypeAccount + 7,

	CMDTypeDevice	= 30,
	CMDRmDevice		= CMDTypeDevice + 1,
	CMDLsDevice		= CMDTypeDevice + 2,
	CMDShowDevice	= CMDTypeDevice + 3,

	CMDTypeService	= 40,
	CMDRegService	= CMDTypeService + 1,
	CMDSetService	= CMDTypeService + 2,
	CMDRmService	= CMDTypeService + 3,
	CMDLsService	= CMDTypeService + 4,
	CMDShowService	= CMDTypeService + 5,
	CMDLsServiceGroup	= CMDTypeService + 6,

	CMDTypeGroup	= 50,
	CMDAddGroup		= CMDTypeGroup + 1,
	CMDSetGroup		= CMDTypeGroup + 2,
	CMDRmGroup		= CMDTypeGroup + 3,
	CMDLsGroup		= CMDTypeGroup + 4,
	CMDShowGroup	= CMDTypeGroup + 5,

	CMDTypeGroupUser= 60,
	CMDJoinGroup	= CMDTypeGroupUser + 1,
	CMDLeaveGroup	= CMDTypeGroupUser + 2,
	CMDLsGroupUser	= CMDTypeGroupUser + 3,

	CMDTypeResource	= 70,
	CMDRmResource	= CMDTypeResource + 1,
	CMDLsResource	= CMDTypeResource + 2,
	CMDShowResource	= CMDTypeResource + 3,

	CMDTypeShare	= 80,
	CMDShare			= CMDTypeShare + 1,
	CMDUnshare			= CMDTypeShare + 2,
	CMDShowShare		= CMDTypeShare + 3,
	CMDLsResourceShare	= CMDTypeShare + 4,
	CMDLsGroupShare		= CMDTypeShare + 5,
	CMDLsDeviceShare	= CMDTypeShare + 6,

	CMDTypeSync		= 90,
	CMDUpdate		= CMDTypeSync + 1,
	CMDSync			= CMDTypeSync + 2,
	CMDSyncQueue	= CMDTypeSync + 3,
	CMDSyncGroup	= CMDTypeSync + 4,
	CMDSyncAccount	= CMDTypeSync + 5,
	CMDSyncDevice	= CMDTypeSync + 6,
	CMDDownSync		= CMDTypeSync + 7,
	CMDUpSync		= CMDTypeSync + 8,
	CMDSyncStat		= CMDTypeSync + 9,

	CMDTypeDiag		= 100,
	CMDDiagSession	= CMDTypeDiag + 1,
	CMDDiagTask		= CMDTypeDiag + 2,
	CMDDiagQueue	= CMDTypeDiag + 3,
	CMDDiagProcess	= CMDTypeDiag + 4,
	CMDDiagThread	= CMDTypeDiag + 5,
	CMDDiagRevKey	= CMDTypeDiag + 6,
	CMDDebugTest	= CMDTypeDiag + 7,
};


}

#endif /* COMMANDS_H_ */
