/*
 * cmd_download.cpp
 *
 *  Created on: 2013/03/06
 *      Author: yasuoki
 */


#include "commands.h"
#include "proc_command.h"
#include "proc_database.h"
#include "proc_requester.h"
#include "proc_listener.h"
#include "task.h"
#include "sentinel.h"
#include "buffer.h"
#include "pjson.h"
#include <syslog.h>
#include <errno.h>
#include <netdb.h>
#include <assert.h>
#include <curl/curl.h>

namespace SST {

class TBDownSync: public TaskBuffer {
public:
	TBDownSync() {
		mJsCommand	= NULL;
		mJsMID		= NULL;
		mJsGName	= NULL;
//		mJsSName	= NULL;
//		mJsRID		= NULL;
//		mJsRName	= NULL;
//		mJsSRev		= NULL;
//		mJsSTime	= 0;
//		mJsCRev		= NULL;
//		mJsCTime	= 0;
		mShare		= NULL;
		mService	= NULL;
		mResource	= NULL;
		mResult		= NULL;
	}

	virtual ~TBDownSync() {
		if( mJsCommand )	delete mJsCommand;
		if( mShare ) 		free(mShare);
		if( mService )		free(mService);
		if( mResource )		free(mResource);
		if( mResult )		delete mResult;
	}

	pjson::json *	mJsCommand;
	pjson::value *	mJsMID;
	pjson::value *	mJsGName;

	ResultShare *	mShare;
	ResultService *	mService;
	ResultResource*	mResource;
	StdBuffer *		mResult;

};

bool CommandProc::cmdDownSync(QueueNode *q)
{
	Task *task	= q->getTask();
	int step	= q->getStep();

	TBDownSync *tb = (TBDownSync*)task->getTaskBuffer();
	if( tb == NULL ) {
		tb = new TBDownSync();
		if( tb == NULL ) {
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
		if( !task->setTaskBuffer(tb) ) {
			delete tb;
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
 	}

	switch(step) {
	case 0:
		{
			tb->mJsCommand = q->detouchJSONMessage();
			pjson::value *vCmd = tb->mJsCommand->get("downSync");
			if( vCmd->vt != pjson::vt_object ) {
				return taskResponse(q, ErrorParameter, "%s. \"downSync\" is not object.", codeToMessgae(ErrorParameter));
			}

			tb->mJsMID	= tb->mJsCommand->get("shareId",  vCmd);
			tb->mJsGName= tb->mJsCommand->get("gadget",  vCmd);

			if( tb->mJsMID && tb->mJsMID->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"shareId\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsGName && tb->mJsGName->vt != pjson::vt_string ) {
				return taskResponse(q, ErrorParameter, "%s. \"gadget\" type.", codeToMessgae(ErrorParameter));
			}
			if( tb->mJsMID == NULL ) {
				return taskResponse(q, ErrorParameter, "%s. \"shareId\" value.", codeToMessgae(ErrorParameter));
			}
			QueryKeyType mref;
			mref.mId	= tb->mJsMID->vString;
			mref.mName	= NULL;
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryShare(NULL, &mref);
			return task->call(qn, step+1);
		}
		break;
	case 1:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "%s Share info load failed.", res->getMessagePtr());
			}
			tb->mShare		= (ResultShare*)(res->mResult);
			res->mResult	= NULL;

			QueryKeyType rref;
			rref.mId	= tb->mShare->mShare.resourceId;;
			rref.mName	= NULL;
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryResource(NULL, &rref);
			return task->call(qn, step+1);
		}
		break;
	case 2:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "%s Resource info load failed.", res->getMessagePtr());
			}
			tb->mResource	= (ResultResource*)(res->mResult);
			res->mResult	= NULL;

			if( tb->mJsGName ) {
				size_t i;
				for( i = 0; i < tb->mResource->mResource.gadgetCount; i++ ) {
					GadgetInfo *gadget = &tb->mResource->mResource.gadgetArray[i];
					if( strcmp(gadget->name, tb->mJsGName->vString) == 0 ) break;
				}
				if( i == tb->mResource->mResource.gadgetCount ) {
					return taskResponse(q, ErrorNotFound, "%s. Gadget info not found.", codeToMessgae(ErrorNotFound));
				}
			}

			QueryKeyType sref;
			sref.mId	= tb->mResource->mResource.serviceId;
			sref.mName	= NULL;
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryService(&sref);
			return task->call(qn, step+1);
		}
		break;
	case 3:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "%s Service info load failed.", res->getMessagePtr());
			}
			ServiceInfo *service = &((ResultService*)res->mResult)->mService;

			const char *p = tb->mResource->mResource.refURL;
			while( *p ) {
				if( *p == '?' ) break;
				p++;
			}

			StdBuffer get_url;
			if( tb->mJsGName ) {
				CURL *curl;
				curl = curl_easy_init();
				if( !curl) {
					return taskResponse(q, ErrorRuntime, "%s CURL init failed.", codeToMessgae(ErrorRuntime));
				}
				char *gn = curl_easy_escape(curl, tb->mJsGName->vString, 0);

				if( *p == '?' ) {
					get_url.addfmt("%s&opt=get_gadget_%s", tb->mResource->mResource.refURL, gn);
				} else {
					get_url.addfmt("%sget_gadget_%s", tb->mResource->mResource.refURL, gn);
				}
				curl_free(gn);
				curl_easy_cleanup(curl);
			} else {
				if( *p == '?' ) {
					get_url.addfmt("%s&opt=get_resource", tb->mResource->mResource.refURL);
				} else {
					get_url.addfmt("%sget_resource", tb->mResource->mResource.refURL);
				}
			}
			const char *user = NULL;
			const char *pswd = NULL;
			if( service->authType == AuthExternURL ) {
				user = task->getUserId();
				pswd = task->getPasswd();
			}

			QnHTTPRequest *qn = new QnHTTPRequest(task);
			qn->setGetRequest(get_url.getPtr());
			if( user && pswd ) {
				qn->setAccount(user, pswd);
			}
			return task->call(qn, step+1);
		}
	case 4:
		{
			QnHTTPResult *res	= (QnHTTPResult*)q;
			ErrorCode	code	= res->getResultCode();
			if( code != 0 || res->mStatusCode != 200 ) {
				if( code == 0 ) {
					code = ErrorHTTP;
				}
				return taskResponse(q, code, "%s HTTP Download error. statusCode=%d.",
						codeToMessgae(code),
						res->mStatusCode);
			}

			tb->mResult = new StdBuffer();
			tb->mResult->add(res->mBody.getPtr(), res->mBody.size());

			QnDBRegister *qn = new QnDBRegister(task);
			QueryKeyType dref;
			QueryKeyType mref;
			dref.mId 	= task->getDeviceId();
			dref.mName	= NULL;
			mref.mId	= tb->mShare->mShare.id;
			mref.mName	= NULL;
			taskLog(q, LOG_DEBUG, "body=%d dev=%s shareid=%s", tb->mResult->size(), dref.mId, mref.mId);
			qn->registDeviceShare(&dref, &mref);
			return task->call(qn, step+1);
		}
		break;
	case 5:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "%s Device share info add failed.", res->getMessagePtr());
			}

			pjson::builder jb;
			if( !jb.init(256) ||
				!jb.beginObject() ||
				!jb.addObjectProp("result", 6) ||
				!jb.valueInt(0) ||
				!jb.addObjectProp("sequence", 8) ||
				!jb.valueInt(task->getSequence()) ||
				!jb.addObjectProp("shareId", 7) ||
				!jb.valueString(tb->mShare->mShare.id) ||
				!jb.addObjectProp("revision", 8) ||
				!jb.valueInt(tb->mResource->mResource.revision) ) {
				taskLog(q, LOG_ERR, "%s. json builder failed(1) code=%d", jb.getError());
				return false;
			}
			if( tb->mJsGName ) {
				if( !jb.addObjectProp("gadget", 6) ||
					!jb.valueString(tb->mJsGName->vString) ) {
					taskLog(q, LOG_ERR, "%s. json builder failed(2) code=%d", jb.getError());
					return false;
				}
			}
			if( !jb.addObjectProp("rawsize", 7) ||
				!jb.valueInt(tb->mResult->size()) ||
				!jb.endObject() ) {
				taskLog(q, LOG_ERR, "%s. json builder failed(3) code=%d", jb.getError());
				return false;
			}

			StdBuffer buff;
			pjson::json *js = jb.detouch();
			js->getText(&buff, true);
			buff.add("\r\n\r\n", 4);

			QnResult *r = new QnResult(task);
			r->mType	= QueueTypeRawResult;
			r->setResult(q->getFunction(), ErrorOk, buff.getPtr(), buff.size() );
			buff.clear();
			r->addResult(tb->mResult->getPtr(), tb->mResult->size());

			return task->endTask(r);
		}
	}
	taskLog(q, LOG_ERR, "unknown step=%d.", step);
	return false;
}
}



