/*
 * buffer.cpp
 *
 *  Created on: 2012/12/08
 *      Author: yasuoki
 */

#include "buffer.h"

#include <stdio.h>
#include <stdarg.h>
#include <memory.h>
#include <malloc.h>

namespace SST {


bool Buffer::addfmt(const char *fmt, ...)
{
    va_list ap;
	bool r;
    va_start(ap, fmt);
    r = addvafmt(fmt, ap);
    va_end(ap);
    return r;
}

bool Buffer::addvafmt(const char *fmt, va_list ap)
{
    char buf[1024];
    char *out = buf;
    int outSize = sizeof(buf);
    va_list ap2;
    va_copy(ap2, ap);
    int size = vsnprintf(out, outSize, fmt, ap2);
    va_end(ap2);
    if( size > outSize ) {
    	outSize = size + 10;
    	out = (char*)malloc(outSize);
    	if( !out ) {
    		return false;
    	}
        va_copy(ap2, ap);
        size = vsnprintf(out, outSize, fmt, ap2);
        va_end(ap2);
    	if( size > outSize ) {
    		free(out);
    		return false;
    	}
    }
	bool ret = add(out,size);
   	if( out != buf )
    	free(out);
   	return ret;
}

size_t Buffer::seek(size_t size)
{
	char buff[1024];
	size_t rs;
	size_t ss = 0;
	while(size > 0) {
		rs = this->size() < size ? this->size() : size;
		rs = rs < sizeof(buff) ? rs : sizeof(buff);
		size_t gs = get(buff, rs);
		size -= gs;
		ss += gs;
		if( gs < rs ) break;
	}
	return ss;
}

}

