/*
 * worker.h
 *
 *  Created on: 2012/12/10
 *      Author: yasuoki
 */

#ifndef WORKER_H_
#define WORKER_H_


#include "../include/sst_types.h"
#include "linklist.h"
#include "task.h"
#include <time.h>
#include <semaphore.h>

namespace SST {

class ProcThread {
public:
	ProcThread();
	~ProcThread();

	bool	init(Scheduler *pool);
	bool	assignIfIdle();
	bool	assignIfStop();
	bool	run();
	bool	execute(Process *proc);
	void	stop();
	bool	isAssigned() const;
	bool	isExecuting() const;
	pthread_t getThreadHandle() { return mThreadHandle; }
	Process *getProcess() { return mProc; }

protected:
	static void *	threadEntry(void *);
	void	*		mainLoop();

	bool			mDoStop;
	bool			mAssign;
	Scheduler *		mPool;
	pthread_t 		mThreadHandle;
	pthread_t*		mThreadHandlePtr;
	sem_t			mSem;
	Process *		mProc;
};

class WaitQueue : public LinkListNode {
public:
	WaitQueue(QueueNode *q, int waitSec);
	~WaitQueue();

	QueueNode *	mQueue;
	timespec	mWaitSec;
};

class Scheduler
{
public:
	Scheduler();
	~Scheduler();

	bool 	configure(Sentinel *obj, Conf *conf);
	ProcThread* assign() const;
	void	schedule();
	bool	setQueueTimer(QueueNode *q, int waitSec);
	void 	stop();
	void	clear();

	bool	diag(pjson::builder &jb);

	LockObject		mLock;
	Sentinel *		mSentinel;

protected:
	static void *	scheduleThreadEntry(void *);
	void	*		scheduleLoop();
	void			scheduleQueue();
	void			scheduleTimer();

	ProcThread *	mWorkerPtr;
	int				mWorkerCnt;

	LinkList		mQueueTimerList;

	bool			mDoStop;
	sem_t			mSem;
	pthread_t 		mThreadHandle;
	pthread_t*		mThreadHandlePtr;
};

}

#endif /* WORKER_H_ */
