/*
 * queue.h
 *
 *  Created on: 2012/07/04
 *      Author: yasuoki
 */

#ifndef QUEUE_H_
#define QUEUE_H_

#include "../include/sst_types.h"
#include "linklist.h"
#include "pjson.h"
#include "stdBuffer.h"
#include "commands.h"

#include <string.h>
#include <semaphore.h>
#include <netinet/in.h>
#include <arpa/inet.h>

namespace SST {


enum QueueType {
	QueueTypeBase		= 0,
	QueueTypeNode		= 1,
	QueueTypeResult		= 2,
	QueueTypeRawResult	= 3,
	QueueTypeComSend	= 4,
	QueueDbQuery		= 5,
	QueueDbRegister		= 6,
	QueueDbResult		= 7,
	QueueHTTPRequest	= 8,
	QueueHTTPResponse	= 9,
	QueueCommUpdate		= 10,
};

class QueueNode;

class Queue : protected LinkList
{
public:
	Queue();
	virtual ~Queue();

	void		clear()	{
		mTopId	= 0;
		LinkList::clear(true);
	}
	bool		empty() const { return LinkList::empty(); }
	bool		put(QueueNode *node);
	QueueNode *	get();
	QueueNode *	next() const { return (QueueNode*)LinkList::getTop(); }
	unsigned long long getNextId() const;
	LockObject &getLockObject() { return mLock; }
	size_t		size() const { return LinkList::getSize(); }
protected:
	sem_t				mQevent;
	unsigned long long	mTopId;
};


class QueueNode : public LinkListNode
{
private:
	QueueNode(const QueueNode &d);
public:
	QueueNode(Task *task, Process *proc=NULL, int func=0, int step=0);
	virtual ~QueueNode();
	unsigned long long	getId() const { return mId; }
	int			getType() const { return mType; }
	Task *		getTask() const { return mTask; }

	void		setProcess(Process *proc, int func, int step) {
		mProc	= proc;
		mFunc	= func;
		mStep	= step;
	}
	Process *	getProcess() const	{ return mProc; }
	int			getFunction() const { return mFunc; }
	int			getStep() const		{ return mStep; }

	void		setMessage(const char *fmt, ... );
	void		setMessage(const char *fmt, va_list ap);
	void		setMessage(pjson::builder &jb);
	const char *	getMessagePtr() { return mMsg ? mMsg->getPtr() : NULL; }
	Buffer *	getMessage() { return mMsg; }
	void		setJSONMessage(pjson::json *js) {
		if( mJson ) delete mJson;
		mJson	= js;
	}
	const pjson::json *	getJSONMessage() { return mJson; }
	pjson::json *	detouchJSONMessage() { pjson::json *js = mJson; mJson = NULL;  return js; }

	int			getSequence() { return mSequence; }
	void		setSequence(int seq) { mSequence = seq; }

	bool		setWaitTime(int sec) {
		struct timespec ts;
		if( clock_gettime(CLOCK_REALTIME, &ts) == -1 ) {
			return false;
		}
		mWaitFor	= ts.tv_sec + sec;
		return true;
	}
	time_t		getWaitTime() {
		return mWaitFor;
	}

	static unsigned long long sIdSeq;
	unsigned long long	mId;
	int			mType;
	Task *		mTask;
	bool		mWaitResult;
	int			mSequence;
	time_t		mWaitFor;

	Process *	mProc;
	int			mFunc;
	int			mStep;

	StdBuffer 	*mMsg;
	pjson::json	*mJson;
};

class QnResult : public QueueNode
{
public:
	QnResult(Task *task) : QueueNode(task) {
		mType		= QueueTypeResult;
		mResultType	= 0;
		mResultCode	= ErrorOk;
	}
	~QnResult() {
	}
	void	setResult(int type, ErrorCode code);
	void	setResult(int type, ErrorCode code, const char *fmt, ... );
	void	setResult(int type, ErrorCode code, const char *fmt, va_list ap);
	void	setResult(int type, ErrorCode code, pjson::json *js);
	void	setResult(int type, ErrorCode code, const char *buffer, size_t size);
	void	addResult(const char *buffer, size_t size);

	int			getResultType() const { return mResultType; }
	ErrorCode	getResultCode() const { return mResultCode; }

	int			mResultType;
	ErrorCode	mResultCode;
};

}


#endif /* QUEUE_H_ */
