/*
 * database.h
 *
 *  Created on: 2012/06/08
 *      Author: yasuoki
 */

#ifndef DATABASE_H_
#define DATABASE_H_

#include "../include/sst_types.h"
#include "process.h"
#include "db_port.h"

namespace SST {

enum DatabaseCommand {
	DBCMDNull				= 0,
	DBCMDService			= 1,	// QueryBase(SREF)
	DBCMDServicePWList		= 2,	// QueryRange
	DBCMDServicePRList		= 3,	// QueryRange
	DBCMDServiceList		= 4,	// QueryRange
	DBCMDServiceGroupList	= 5,	// QueryRange
	DBCMDAccount			= 6,	// QueryKey1(NULL,AREF)
	DBCMDAccountList		= 7,	// QueryKey1Range([SREF,GREF],FROM,TO)
	DBCMDAccountIsLock		= 8,	//
	DBCMDDevice				= 9,	// QueryKey1(NULL,DREF)
	DBCMDDeviceCount		= 10,	// QueryKey1(NULL,[AREF])
	DBCMDDeviceList			= 11,	// QueryKey1Range(NULL,[AREF],FROM,TO)
	DBCMDDeviceShareCount	= 12,	// QueryKey1(NULL,[DREF])
	DBCMDDeviceShareList	= 13,	// QueryKey1Range(NULL,[DREF],FROM,TO)
	DBCMDGroup				= 14,	// QueryKey1([SREF],GREF)
	DBCMDGroupCount			= 15,	// QueryKey1([SREF],[AREF])
	DBCMDGroupList			= 16,	// QueryRange([SREF],[AREF],FROM,TO)
	DBCMDIsGroupMember		= 17,	// QueryKey2(SREF,[GREF],AREF)
//	DBCMDGroupShareList		= 18,	// QueryKey1([SREF],GREF)
	DBCMDResource			= 19,	// QueryKey1([SREF],RREF)
	DBCMDResourceList		= 20,	// QueryRange([SREF],FROM,TO)
	DBCMDShare				= 21,	// QueryKey2([SREF],RREF,MREF)
	DBCMDShareList			= 22,	// QueryKey1Range(SREF,RREF)
	DBCMDSync				= 24,	// QueryKey1(SREF,RREF)
	DBCMDSyncQueue			= 25,	// QueryBase(SREF)
	DBCMDNode				= 26,	// QueryBase(NREF)
	DBCMDNodeList			= 27,	// QueryRange(FROM,TO)
	DBCMDRegService			= 28,
	DBCMDRegAccountLock		= 29,	//
	DBCMDRegAccountUnlock	= 30,	//
	DBCMDRegAccount			= 31,
	DBCMDRegDevice			= 32,
	DBCMDRegDeviceShare		= 33,
	DBCMDRegGroup			= 34,
	DBCMDRegResource		= 35,
	DBCMDRegGroupAccount	= 36,
	DBCMDRegShare			= 37,
	DBCMDRegSync			= 38,
	DBCMDRegSyncQueue		= 39,
	DBCMDRegNode			= 40,

	DBCMDRemAccount			= 41,
	DBCMDRemDevice			= 42,
	DBCMDRemGroupAccount	= 43,
	DBCMDRemGroup			= 44,
	DBCMDRemResource		= 45,
	DBCMDRemShare			= 46,

	DBCMDRegResult			= 47,
	DBCMDCountResult		= 48,
	DBCMDResCode			= 49,
	DBCMDResId				= 50,
	DBCMDResCount			= 51,
	DBCMDResList			= 52,
};

/////////////////////////////////////////////////////////////////////
class QnDBQuery : public QueueNode
{
private:
	QnDBQuery(const QnDBQuery &d);
public:
	QnDBQuery(Task *task);
	~QnDBQuery();

protected:
	bool qbase(const QueryKeyType *sref) {
		size_t size = DBUtil::sizeofQBase(sref);
		char *ptr = (char*)malloc(size);
		mQuery	= (QueryBase*)ptr;

		char *ext	= ptr + sizeof(QueryBase);
		DBUtil::writeQBase(mQuery, ext, sref);
		return true;
	}
	bool key1(const QueryKeyType *sref, const QueryKeyType *key1) {
		size_t size	= sizeof(QueryKey1)
					+ DBUtil::sizeofQBase(sref)
					+ DBUtil::sizeofKey(key1);
		char *ptr = (char*)malloc(size);
		mQuery	= (QueryBase*)ptr;
		QueryKey1 *pt = (QueryKey1*)mQuery;
		char *ext	= ptr + sizeof(QueryKey1);
		ext = DBUtil::writeKey(&pt->mSREF, ext, sref);
		ext = DBUtil::writeKey(&pt->mKey1, ext, key1);
		return true;
	}
	bool key2(const QueryKeyType *sref, const QueryKeyType *key1, const QueryKeyType *key2) {
		size_t size	= sizeof(QueryKey2)
					+ DBUtil::sizeofQBase(sref)
					+ DBUtil::sizeofKey(key1)
					+ DBUtil::sizeofKey(key2);
		char *ptr = (char*)malloc(size);
		mQuery	= (QueryBase*)ptr;

		QueryKey2 *pt = (QueryKey2*)mQuery;
		char *ext	= ptr + sizeof(QueryKey2);
		ext = DBUtil::writeKey(&pt->mSREF, ext, sref);
		ext = DBUtil::writeKey(&pt->mKey1, ext, key1);
		ext = DBUtil::writeKey(&pt->mKey2, ext, key2);
		return true;
	}
	bool range(const QueryKeyType *sref, const QueryRangeType *src) {
		size_t size	= sizeof(QueryRange)
					+ DBUtil::sizeofQBase(sref)
					+ DBUtil::sizeofRange(src);
		char *ptr = (char*)malloc(size);
		mQuery	= (QueryBase*)ptr;

		QueryRange *pt = (QueryRange*)mQuery;
		char *ext	= ptr + sizeof(QueryRange);
		ext = DBUtil::writeKey(&pt->mSREF, ext, sref);
		ext = DBUtil::writeRange(&pt->mRange, ext, src);
		return true;
	}
	bool key1Range(const QueryKeyType *sref, const QueryKeyType *key1, const QueryRangeType *src) {
		size_t size	= sizeof(QueryKey1Range)
					+ DBUtil::sizeofQBase(sref)
					+ DBUtil::sizeofKey(key1)
					+ DBUtil::sizeofRange(src);
		char *ptr = (char*)malloc(size);
		mQuery	= (QueryBase*)ptr;

		QueryKey1Range *pt = (QueryKey1Range*)mQuery;
		char *ext	= ptr + sizeof(QueryKey1Range);
		ext = DBUtil::writeKey(&pt->mSREF, ext, sref);
		ext = DBUtil::writeKey(&pt->mKey1, ext, key1);
		ext = DBUtil::writeRange(&pt->mRange, ext, src);
		return true;
	}
	bool key1Index(const QueryKeyType *sref, const QueryKeyType *key1, size_t index) {
		size_t size	= sizeof(QueryKey1Index)
					+ DBUtil::sizeofQBase(sref)
					+ DBUtil::sizeofKey(key1);
		char *ptr = (char*)malloc(size);
		mQuery	= (QueryBase*)ptr;
		QueryKey1Index *pt = (QueryKey1Index*)mQuery;
		char *ext	= ptr + sizeof(QueryKey1Index);
		ext = DBUtil::writeKey(&pt->mSREF, ext, sref);
		ext = DBUtil::writeKey(&pt->mKey1, ext, key1);
		pt->mIndex	= index;
		return true;
	}
public:
	bool queryService(const QueryKeyType *sref) {
		mFunc	= (int)DBCMDService;
		return qbase(sref);
	}
	bool queryServicePWList(const QueryKeyType *sref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDServicePWList;
		return range(sref, src);
	}
	bool queryServicePRList(const QueryKeyType *sref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDServicePRList;
		return range(sref, src);
	}
	bool queryServiceList(const QueryKeyType *sref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDServiceList;
		return range(sref, src);
	}
	bool queryServiceGroupList(const QueryKeyType *sref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDServiceGroupList;
		return range(sref, src);
	}
	bool queryAccount(const QueryKeyType *aref) {
		mFunc	= (int)DBCMDAccount;
		return key1(NULL, aref);
	}
	bool removeAccount(const QueryKeyType *aref) {
		mFunc	= (int)DBCMDRemAccount;
		return key1(NULL, aref);
	}
	bool queryAccountList(const QueryKeyType *sref, const QueryKeyType *gref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDAccountList;
		return key1Range(sref, gref, src);
	}
	bool queryAccountIsLock(const QueryKeyType *sref, const QueryKeyType *aref) {
		mFunc	= (int)DBCMDAccountIsLock;
		return key1(sref, aref);
	}
	bool queryDevice(const QueryKeyType *dref) {
		mFunc	= (int)DBCMDDevice;
		return key1(NULL, dref);
	}
	bool removeDevice(const QueryKeyType *dref) {
		mFunc	= (int)DBCMDRemDevice;
		return key1(NULL, dref);
	}
	bool queryDeviceCount(const QueryKeyType *aref) {
		mFunc	= (int)DBCMDDeviceCount;
		return key1(NULL, aref);
	}
	bool queryDeviceList(const QueryKeyType *aref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDDeviceList;
		return key1Range(NULL, aref, src);
	}
	bool queryDeviceShareCount(const QueryKeyType *sref, const QueryKeyType *dref) {
		mFunc	= (int)DBCMDDeviceShareCount;
		return key1(sref, dref);
	}
	bool queryDeviceShareList(const QueryKeyType *dref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDDeviceShareList;
		return key1Range(NULL, dref, src);
	}
	bool queryGroup(const QueryKeyType *sref, const QueryKeyType *gref) {
		mFunc	= (int)DBCMDGroup;
		return key1(sref, gref);
	}
	bool queryGroupCount(const QueryKeyType *aref) {
		mFunc	= (int)DBCMDGroupCount;
		return key1(NULL,aref);
	}
	bool queryGroupList(const QueryKeyType *aref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDGroupList;
		return key1Range(NULL, aref, src);
	}
	bool queryGroupMember(const QueryKeyType *sref, const QueryKeyType *gref, const QueryKeyType *aref) {
		mFunc	= (int)DBCMDIsGroupMember;
		return key2(sref, gref, aref);
	}
	bool queryResource(const QueryKeyType *sref, const QueryKeyType *rref) {
		mFunc	= (int)DBCMDResource;
		return key1(sref, rref);
	}
	bool queryResourceList(const QueryKeyType *sref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDResourceList;
		return range(sref,src);
	}
	bool queryShare(const QueryKeyType *sref, const QueryKeyType *mref) {
		mFunc	= (int)DBCMDShare;
		return key1(sref, mref);
	}
	bool queryShareList(const QueryKeyType *sref, const QueryKeyType *gref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDShareList;
		return key1Range(sref, gref, src);
	}
	bool querySync(const QueryKeyType *sref, const QueryKeyType *rref) {
		mFunc	= (int)DBCMDSync;
		return key1(sref, rref);
	}
	bool querySyncQueue(const QueryKeyType *sref) {
		mFunc	= (int)DBCMDSyncQueue;
		return qbase(sref);
	}
//	bool querySession(const QueryKeyType *sref) {
//		mFunc	= (int)DBCMDSession;
//		return qbase(sref);
//	}
//	bool querySessionList(const QueryKeyType *sref, const QueryRangeType *src) {
//		mFunc	= (int)DBCMDSessionList;
//		return range(sref, src);
//	}
	bool queryNode(const QueryKeyType *nref) {
		mFunc	= (int)DBCMDNode;
		return qbase(nref);
	}
	bool queryNodeList(const QueryKeyType *sref, const QueryRangeType *src) {
		mFunc	= (int)DBCMDNodeList;
		return range(sref, src);
	}
	bool removeGroupAccount(const QueryKeyType *sref, const QueryKeyType *gref, const QueryKeyType *aref) {
		mFunc	= (int)DBCMDRemGroupAccount;
		return key2(sref, gref, aref);
	}
	bool removeGroup(const QueryKeyType *sref, const QueryKeyType *gref) {
		mFunc	= (int)DBCMDRemGroup;
		return key1(sref, gref);
	}
	bool removeResource(const QueryKeyType *sref, const QueryKeyType *rref) {
		mFunc	= (int)DBCMDRemResource;
		return key1(sref, rref);
	}
	bool removeShare(const QueryKeyType *sref, const QueryKeyType *mref) {
		mFunc	= (int)DBCMDRemShare;
		return key1(sref, mref);
	}
	QueryBase *		mQuery;
};

/////////////////////////////////////////////////////////////////////
class QnDBRegister : public QueueNode
{
private:
	QnDBRegister(const QnDBRegister &d);
public:
	QnDBRegister(Task *task);
	virtual ~QnDBRegister();

protected:
	bool sbase(const QueryKeyType *sref) {
		size_t size = sizeof(RegistBase)
					+ DBUtil::sizeofSBase(sref);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistBase *pt = (RegistBase*)mRegist;
		ptr	+= sizeof(RegistBase);
		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
		return true;
	}
	bool key1(const QueryKeyType *sref, const QueryKeyType *key1) {
		size_t size	= sizeof(QueryKey1)
					+ DBUtil::sizeofQBase(sref)
					+ DBUtil::sizeofKey(key1);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;
		QueryKey1 *pt = (QueryKey1*)ptr;
		char *ext	= ptr + sizeof(QueryKey1);
		ext = DBUtil::writeKey(&pt->mSREF, ext, sref);
		ext = DBUtil::writeKey(&pt->mKey1, ext, key1);
		return true;
	}
public:
	bool registAccountLock(const QueryKeyType *sref, const QueryKeyType *aref) {
		mFunc	= (int)DBCMDRegAccountLock;
		return key1(sref, aref);
	}
	bool registAccountUnlock(const QueryKeyType *sref, const QueryKeyType *aref) {
		mFunc	= (int)DBCMDRegAccountUnlock;
		return key1(sref, aref);
	}

	bool registDevice(const DeviceInfo *src) {
		mFunc	= (int)DBCMDRegDevice;
		size_t size	= sizeof(RegistDevice)
					+ DBUtil::sizeofDevice(src);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistDevice *pt = (RegistDevice*)mRegist;
		ptr	+= sizeof(RegistDevice);
		pt->mSREF.mId	= NULL;
		pt->mSREF.mName	= NULL;
		ptr	= DBUtil::writeDevice(&pt->mDevice, ptr, src);
		return true;
	}

//	bool registSession(const QueryKeyType *sref, const SessionInfo *src) {
//		mFunc	= (int)DBCMDRegSession;
//		size_t size	= sizeof(RegistSession)
//					+ DBUtil::sizeofSBase(sref)
//					+ DBUtil::sizeofSessionInfo(src);
//		char *ptr = (char*)malloc(size);
//		mRegist	= (RegistBase*)ptr;
//
//		RegistSession *pt = (RegistSession*)mRegist;
//		ptr	+= sizeof(RegistSession);
//		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
//		ptr	= DBUtil::writeSessionInfo(&pt->mSession, ptr, src);
//		return true;
//	}
	bool registService(const ServiceInfo *srv) {
		mFunc	= (int)DBCMDRegService;
		size_t size	= sizeof(RegistService)
					+ DBUtil::sizeofService(srv);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistService *pt = (RegistService*)mRegist;
		ptr	+= sizeof(RegistService);
		ptr	= DBUtil::writeService(&pt->mService, ptr, srv);
		return true;
	}

	bool registAccount(const QueryKeyType *sref, const Account *acc) {
		mFunc	= (int)DBCMDRegAccount;
		size_t size	= sizeof(RegistAccount)
					+ DBUtil::sizeofSBase(sref)
					+ DBUtil::sizeofAccount(acc);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistAccount *pt = (RegistAccount*)mRegist;
		ptr	+= sizeof(RegistAccount);
		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
		ptr	= DBUtil::writeAccount(&pt->mAccount, ptr, acc);
		return true;
	}

	bool registGroup(const QueryKeyType *sref, const GroupInfo *g) {
		mFunc	= (int)DBCMDRegGroup;
		size_t size	= sizeof(RegistGroup)
					+ DBUtil::sizeofSBase(sref)
					+ DBUtil::sizeofGroupInfo(g);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistGroup *pt = (RegistGroup*)mRegist;
		ptr	+= sizeof(RegistGroup);
		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
		ptr	= DBUtil::writeGroupInfo(&pt->mGroup, ptr, g);
		return true;
	}

	bool registGroupAccount(const QueryKeyType *sref, const QueryKeyType *gref, const QueryKeyType *aref) {
		mFunc	= (int)DBCMDRegGroupAccount;
		size_t size	= sizeof(RegistGroupAccount)
					+ DBUtil::sizeofSBase(sref)
					+ DBUtil::sizeofSBase(gref)
					+ DBUtil::sizeofSBase(aref);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistGroupAccount *pt = (RegistGroupAccount*)mRegist;
		ptr	+= sizeof(RegistGroupAccount);
		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
		ptr	= DBUtil::writeKey(&pt->mGroup, ptr, gref);
		ptr	= DBUtil::writeKey(&pt->mAccount, ptr, aref);
		return true;
	}

	bool registResource(const QueryKeyType *sref, const ResourceInfo *pResourceInfo, const GadgetInfo *pGadgetArr, size_t nGadgetCount) {
		mFunc	= (int)DBCMDRegResource;
		size_t size	= sizeof(RegistResource)
					+ DBUtil::sizeofSBase(sref)
					+ DBUtil::sizeofResource(pResourceInfo, pGadgetArr, nGadgetCount);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistResource *pt = (RegistResource*)mRegist;
		ptr	+= sizeof(RegistResource);
		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
		ptr	= DBUtil::writeResource(&pt->mResource, ptr, pResourceInfo, pGadgetArr, nGadgetCount);
		return true;
	}

	bool registDeviceShare(const QueryKeyType *dref, const QueryKeyType *mref) {
		mFunc	= (int)DBCMDRegDeviceShare;
		size_t size	= sizeof(RegistDeviceShare)
					+ DBUtil::sizeofSBase(dref)
					+ DBUtil::sizeofSBase(mref);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistDeviceShare *pt = (RegistDeviceShare*)mRegist;
		ptr	+= sizeof(RegistDeviceShare);
		ptr	= DBUtil::writeKey(&pt->mDREF, ptr, dref);
		ptr	= DBUtil::writeKey(&pt->mMREF, ptr, mref);
		return true;
	}

	bool registShare(const QueryKeyType *sref, const QueryKeyType *rref, const ShareInfo *pShareInfo) {
		mFunc	= (int)DBCMDRegShare;
		size_t size	= sizeof(RegistShare)
					+ DBUtil::sizeofSBase(sref)
					+ DBUtil::sizeofSBase(rref)
					+ DBUtil::sizeofShare(pShareInfo);
		char *ptr = (char*)malloc(size);
		mRegist	= (RegistBase*)ptr;

		RegistShare *pt = (RegistShare*)mRegist;
		ptr	+= sizeof(RegistShare);
		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
		ptr	= DBUtil::writeKey(&pt->mRREF, ptr, rref);
		ptr	= DBUtil::writeShare(&pt->mShare, ptr, pShareInfo);
		return true;
	}

	bool registSyncQueue(SyncQueueCmd cmd, const QueryKeyType *sref, const QueryKeyType *gref, size_t grefCount) {
		mFunc	= (int)DBCMDRegSyncQueue;
		size_t size	= sizeof(RegistSyncQueue)
					+ DBUtil::sizeofKey(sref)
					+ sizeof(QueryKeyType) * grefCount;
		size_t i;
		for( i = 0; i < grefCount; i++ ) {
			size +=  DBUtil::sizeofKey(&gref[i]);
		}
		char *ptr = (char*)malloc(size);
		memset(ptr, 0, size);
		mRegist	= (RegistBase*)ptr;

		RegistSyncQueue *pt = (RegistSyncQueue*)mRegist;
		ptr	+= sizeof(RegistSyncQueue);
		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
		pt->mCmd		= cmd;
		pt->mAREF.mId	= NULL;
		pt->mAREF.mName	= NULL;
		pt->mGREFCount	= grefCount;
		pt->mGREFArr	= (QueryKeyType*)ptr;
		ptr += sizeof(QueryKeyType) * grefCount;
		for( i = 0; i < grefCount; i++ ) {
			ptr	= DBUtil::writeKey(&pt->mGREFArr[i], ptr, &gref[i]);
		}
		return true;
	}
	bool registSyncQueue(SyncQueueCmd cmd, const QueryKeyType *sref, const QueryKeyType *gref, const QueryKeyType *aref) {
		mFunc	= (int)DBCMDRegSyncQueue;
		size_t size	= sizeof(RegistSyncQueue)
					+ sizeof(QueryKeyType) * 2
					+ DBUtil::sizeofKey(gref) +
					+ DBUtil::sizeofKey(aref);

		char *ptr = (char*)malloc(size);
		memset(ptr, 0, size);
		mRegist	= (RegistBase*)ptr;

		RegistSyncQueue *pt = (RegistSyncQueue*)mRegist;
		ptr	+= sizeof(RegistSyncQueue);
		pt->mCmd	= cmd;
		ptr	= DBUtil::writeKey(&pt->mSREF, ptr, sref);
		ptr	= DBUtil::writeKey(&pt->mAREF, ptr, aref);
		pt->mGREFArr	= (QueryKeyType*)ptr;
		ptr += sizeof(QueryKeyType);
		ptr	= DBUtil::writeKey(pt->mGREFArr, ptr, gref);
		pt->mGREFCount	= 0;
		return true;
	}
	RegistBase *	mRegist;
};

/////////////////////////////////////////////////////////////////////
class QnDBResult : public QnResult
{
private:
	QnDBResult(const QnDBResult &d);
public:
	QnDBResult(Task *task);
	~QnDBResult();

	void setDBResult(ErrorCode code, const char *fmt, ... ) {
	    va_list ap;
	    va_start(ap, fmt);
	    return QnResult::setResult(DBCMDResCode, code, fmt, ap);
	}

protected:
	/*
	bool resultBase(int code, const char *msg) {
		size_t size = DBUtil::sizeofRBase(code, msg);
		char *ptr = (char*)malloc(size);
		mResult = (ResultBase*)ptr;
		char *ext = ptr + sizeof(ResultBase);
		DBUtil::writeRBase(mResult, ext, DBCMDResultCode, code, msg );
		return true;
	}
	*/

public:
	bool resultId(ErrorCode code, const char *src) {
		mResultType	= (int)DBCMDResId;
		size_t size	= sizeof(ResultId)
					  + (src ? strlen(src)+1 : 0);
		char *ptr = (char*)malloc(size);
		mResult	= (ResultBase*)ptr;

		ResultId *pt = (ResultId*)mResult;
		ptr	+= sizeof(ResultId);
		if( src ) {
			pt->mId	= ptr;
			strcpy(pt->mId, src);
		} else {
			pt->mId	= NULL;
		}
		setResult(DBCMDResId, code);
		return true;
	}

	bool resultCount(int type, long long int cnt) {
		mResultType	= (int)DBCMDResCount;
		size_t size	= sizeof(ResultCount);
		char *ptr = (char*)malloc(size);
		mResult	= (ResultBase*)ptr;

		ResultCount *pt = (ResultCount*)mResult;
		pt->mCount	= cnt;
		setResult(type, ErrorOk);
		return true;
	}
	bool resultAccount(ResultAccount *res) {
		mResultType	= (int)DBCMDAccount;
		mResult	= (ResultBase*)res;
		return true;
	}

	bool resultDevice(ResultDevice *res) {
		mResultType	= (int)DBCMDDevice;
		mResult	= (ResultBase*)res;
		return true;
	};

	bool resultService(ResultService *res) {
		mResultType	= (int)DBCMDService;
		mResult	= (ResultBase*)res;
		return true;
	};

	bool resultResource(ResultResource *res) {
		mResultType	= (int)DBCMDResource;
		mResult	= (ResultBase*)res;
		return true;
	}

	bool resultGroup(ResultGroup *res) {
		mResultType	= (int)DBCMDGroup;
		mResult	= (ResultBase*)res;
		return true;
	}

	bool resultShare(ResultShare *res) {
		mResultType	= (int)DBCMDShare;
		mResult	= (ResultBase*)res;
		return true;
	}

//	bool resultSession(ResultSession *res) {
//		mResultType	= (int)DBCMDSession;
//		mResult	= (ResultBase*)res;
//		return true;
//	}

	bool resultNode(ResultNode  *res) {
		mResultType	= (int)DBCMDNode;
		mResult	= (ResultBase*)res;
		return true;
	}
	bool resultList(ResultList *res) {
		mResultType	= (int)DBCMDResList;
		mResult	= (ResultBase*)res;
		return true;
	}
/*
	bool resultList(QueryResult result, int code, RecList *src) {
		size_t size	= sizeofRBase(result, code, NULL)
					+ sizeofNodeInfo(src);
		char *ptr = (char*)malloc(size);
		mResult	= (QueryResult*)ptr;

		ResultNode *pt = (ResultNode*)mResult;
		ptr	+= sizeof(ResultNode);
		ptr	= writeRBase(&pt->mBase, ptr, result, code, NULL);
		ptr	= writeNodeInfo(&pt->mNode, ptr, src);
		return true;
		ResultBase		mBase;
		RecList			mList;
	} ResultList;
*/
	ResultBase *	mResult;
};


class Database : public Process
{
public:
	Database();
	~Database();

	virtual bool	configure(Sentinel *obj, Conf *conf);
	virtual void	clear();
	virtual const char *getName() const { return "Database"; }
	virtual const char *getFuncName(int id);

	bool	connect();
	bool	disconnect();
	bool	checkDatabase();

protected:
	virtual bool	exec(QueueNode *q);
	virtual void	stop(QueueNode *q);
	ErrorCode confirmSID(QueueNode *q, DBPort *port, const QueryKeyType *key, char *sid);
	ErrorCode confirmAID(QueueNode *q, DBPort *port, const QueryKeyType *key, char *aid);
	ErrorCode confirmDEV(QueueNode *q, DBPort *port, const QueryKeyType *key, char *dev);
	ErrorCode confirmRID(QueueNode *q, DBPort *port, const QueryKey1 *key, char *rid);
	ErrorCode confirmGID(QueueNode *q, DBPort *port, const QueryKey1 *key, char *gid);
	ErrorCode confirmMID(QueueNode *q, DBPort *port, const QueryKeyType *key, char *rid);

	bool cmdQueryService(QnDBQuery *q, DBPort *port);
	bool cmdQueryServicePWList(QnDBQuery *q, DBPort *port);
	bool cmdQueryServicePRList(QnDBQuery *q, DBPort *port);
	bool cmdQueryServiceList(QnDBQuery *q, DBPort *port);
	bool cmdQueryServiceGroupList(QnDBQuery *q, DBPort *port);
	bool cmdQueryAccount(QnDBQuery *q, DBPort *port);
	bool cmdQueryAccountList(QnDBQuery *q, DBPort *port);
	bool cmdQueryAccountIsLock(QnDBQuery *q, DBPort *port);
	bool cmdQueryDevice(QnDBQuery *q, DBPort *port);
	bool cmdQueryDeviceCount(QnDBQuery *q, DBPort *port);
	bool cmdQueryDeviceList(QnDBQuery *q, DBPort *port);
	bool cmdQueryDeviceShareCount(QnDBQuery *q, DBPort *port);
	bool cmdQueryDeviceShareList(QnDBQuery *q, DBPort *port);
	bool cmdQueryGroup(QnDBQuery *q, DBPort *port);
	bool cmdQueryGroupCount(QnDBQuery *q, DBPort *port);
	bool cmdQueryGroupList(QnDBQuery *q, DBPort *port);
	bool cmdQueryIsGroupMember(QnDBQuery *q, DBPort *port);
	bool cmdQueryResource(QnDBQuery *q, DBPort *port);
	bool cmdQueryResourceList(QnDBQuery *q, DBPort *port);
	bool cmdQueryShare(QnDBQuery *q, DBPort *port);
	bool cmdQueryShareList(QnDBQuery *q, DBPort *port);
	bool cmdQuerySync(QnDBQuery *q, DBPort *port);
	bool cmdQuerySyncQueue(QnDBQuery *q, DBPort *port);
	/*
	bool cmdQuerySession(QnDBQuery *q, DBPort *port);
	bool cmdQuerySessionList(QnDBQuery *q, DBPort *port);
	*/
	bool cmdQueryNode(QnDBQuery *q, DBPort *port);
	bool cmdQueryNodeList(QnDBQuery *q, DBPort *port);

	bool cmdRegService(QnDBRegister *q, DBPort *port);
	bool cmdRegAccountLock(QnDBRegister *q, DBPort *port);
	bool cmdRegAccountUnlock(QnDBRegister *q, DBPort *port);
	bool cmdRegAccount(QnDBRegister *q, DBPort *port);
	bool cmdRegDevice(QnDBRegister *q, DBPort *port);
	bool cmdRegGroup(QnDBRegister *q, DBPort *port);
	bool cmdRegGroupAccount(QnDBRegister *q, DBPort *port);
	bool cmdRegResource(QnDBRegister *q, DBPort *port);
	bool cmdRegShare(QnDBRegister *q, DBPort *port);
	bool cmdRegDeviceShare(QnDBRegister *q, DBPort *port);
	bool cmdRegSync(QnDBRegister *q, DBPort *port);
	bool cmdRegSyncQueue(QnDBRegister *q, DBPort *port);
	bool cmdRegNode(QnDBRegister *q, DBPort *port);

	bool cmdRemAccount(QnDBQuery *q, DBPort *port);
	bool cmdRemDevice(QnDBQuery *q, DBPort *port);
	bool cmdRemGroupAccount(QnDBQuery *q, DBPort *port);
	bool cmdRemGroup(QnDBQuery *q, DBPort *port);
	bool cmdRemShare(QnDBQuery *q, DBPort *port);


	DBPool	mDBPool;
	int		mThreads;
	LockObject		mLock;

};

}

#endif /* DATABASE_H_ */
