/*
 * linklist.h
 *
 *  Created on: 2012/12/08
 *      Author: yasuoki
 */

#ifndef LINKLIST_H_
#define LINKLIST_H_

#include "../include/sst_types.h"
#include "lock.h"
#include <semaphore.h>

namespace SST {

class LinkListNode
{
public:
	LinkListNode() {
		mPrev	= NULL;
		mNext	= NULL;
	}
	LinkListNode(const LinkListNode &d) {
		mPrev	= NULL;
		mNext	= NULL;
	}
	virtual ~LinkListNode() {}

	LinkListNode *	mPrev;
	LinkListNode *	mNext;
};

class LinkList
{
public:
	LinkList() {
		mSize	= 0;
		mTop	= NULL;
		mBottom	= NULL;;
	}
	virtual ~LinkList() {
		clear(false);
	}
	void clear(bool needDelete) {
		WRITE_LOCK(mLock);
		if( needDelete ) {
			LinkListNode *node = mTop;
			while(node) {
				LinkListNode *next = node->mNext;
				delete node;
				node = next;
			}
		}
		mTop	= NULL;
		mBottom	= NULL;
		mSize	= 0;
	}
	bool addTop(LinkListNode *node) {
		WRITE_LOCK(mLock);
		node->mPrev	= NULL;
		node->mNext	= mTop;
		if( mTop )
			mTop->mPrev	= node;
		else
			mBottom		= node;
		mTop		= node;
		mSize++;
		return true;
	}
	bool addBottom(LinkListNode *node) {
		WRITE_LOCK(mLock);
		node->mPrev	= mBottom;
		node->mNext	= NULL;
		if( mBottom )
			mBottom->mNext	= node;
		else
			mTop			= node;
		mBottom		= node;
		mSize++;
		return true;
	}
	LinkListNode *removeTop() {
		WRITE_LOCK(mLock);
		if( mTop == NULL ) return NULL;

		LinkListNode *node = mTop;
		mTop	= node->mNext;
		if( mTop )
			mTop->mPrev	= NULL;
		else
			mBottom		= NULL;
		mSize--;
		node->mPrev	= NULL;
		node->mNext	= NULL;
		return node;
	}
	LinkListNode *removeBottom() {
		WRITE_LOCK(mLock);
		if( mBottom == NULL ) return NULL;

		LinkListNode *node = mBottom;
		mBottom	= node->mPrev;
		if( mBottom )
			mBottom->mNext	= NULL;
		else
			mTop			= NULL;
		mSize--;
		node->mPrev	= NULL;
		node->mNext	= NULL;
		return node;
	}
	LinkListNode *removeNode(LinkListNode *node) {
		WRITE_LOCK(mLock);
		if( node == NULL ) return NULL;

		if( node->mPrev )
			node->mPrev->mNext	= node->mNext;
		else if( node == mTop )
			mTop = node->mNext;
		if( node->mNext )
			node->mNext->mPrev	= node->mPrev;
		else if( node == mBottom )
			mBottom	= node->mPrev;
		mSize--;
		node->mPrev	= NULL;
		node->mNext	= NULL;
		return node;
	}
	LinkListNode *getTop() const {
		READ_LOCK(const_cast<LinkList*>(this)->mLock);
		LinkListNode *node = mTop;
		return node;
	}
	LinkListNode *getBottom() const {
		READ_LOCK(const_cast<LinkList*>(this)->mLock);
		LinkListNode *node = mBottom;
		return node;
	}
	LinkListNode *getNext(LinkListNode *node) const {
		READ_LOCK(const_cast<LinkList*>(this)->mLock);
		LinkListNode *next = node->mNext;
		return next;
	}
	size_t	getSize() const {
		READ_LOCK(const_cast<LinkList*>(this)->mLock);
		size_t r = mSize;
		return r;
	}
	bool	empty() const 	{
		READ_LOCK(const_cast<LinkList*>(this)->mLock);
		bool r = mSize == 0;
		return r;
	}

protected:
	LinkListNode *	mTop;
	LinkListNode *	mBottom;
	LockObject		mLock;
	size_t			mSize;
};

}


#endif /* LINKLIST_H_ */
