/*
 * db_port.cpp
 *
 *  Created on: 2012/12/11
 *      Author: yasuoki
 */

#include "db_port.h"
#include "redis_db.h"

namespace SST {

DBPort::DBPort()
{
	mSentinel	= NULL;
	mProcess	= false;
}

DBPort::~DBPort()
{
}

bool DBPort::isProcess()
{
	return mProcess;
}

void DBPort::setProcess()
{
	mProcess	= true;
}

void DBPort::endProcess()
{
	mProcess	= false;
}

bool DBPort::configure(Sentinel *obj, Conf *conf)
{
	mSentinel	= obj;
	return true;
}

bool DBPort::checkAccountName(const char *name)
{
	return true;
}

//////////////////////////////////////////////
#define BLOCK_SIZE	8
DBPool::PortList::PortList()
{
	mSize	= 0;
	mBlock	= 0;
	mPtr	= NULL;
}

DBPool::PortList::~PortList()
{
	clear();
}

void DBPool::PortList::clear()
{
	if( mBlock != 0 ) {
		size_t i;
		for( i = 0; i < mSize; i++ )
			delete mPtr[i];
		free(mPtr);
	}
	mSize	= 0;
	mBlock	= 0;
	mPtr	= NULL;
}

bool DBPool::PortList::add(DBPort *t)
{
	if( mBlock - mSize < 1 ) {
		size_t	new_block	= mBlock + BLOCK_SIZE;
		DBPort ** new_ptr = (DBPort**)realloc(mPtr, sizeof(DBPort*)*new_block);
		if( new_ptr == NULL ) {
			return false;
		}
		mPtr	= new_ptr;
		mBlock	= new_block;
	}
	mPtr[mSize++] = t;
	return true;
}

DBPort * DBPool::PortList::get(size_t pos)
{
	return mPtr[pos];
}

size_t DBPool::PortList::size() const
{
	return mSize;
}

bool DBPool::PortList::empty() const
{
	return mSize == 0;
}

//////////////////////////////////////////////
DBPool::DBPool()
{
}

DBPool::~DBPool()
{
}

bool DBPool::addPort(DBPort *port)
{
	return mPortList.add(port);
}

void DBPool::clear()
{
	WRITE_LOCK(mLock);
	mPortList.clear();
}

DBPort * DBPool::assignPort()
{
	WRITE_LOCK(mLock);
	size_t i;
	for( i = 0; i < mPortList.size(); i++ ) {
		DBPort *port = mPortList.get(i);
		if( !port->isProcess() ) {
			port->setProcess();
			return port;
		}
	}
	return NULL;
}

void DBPool::freePort(DBPort *port)
{
	WRITE_LOCK(mLock);
	port->endProcess();
}

}

