/*
 * cmd_share.cpp
 *
 *  Created on: 2013/01/31
 *      Author: yasuoki
 */

#include "commands.h"
#include "proc_command.h"
#include "proc_database.h"
#include "proc_requester.h"
#include "task.h"
#include "sentinel.h"
#include "buffer.h"
#include "pjson.h"
#include <syslog.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

namespace SST {


bool CommandProc::cmdShare(QueueNode *q)
{
	return taskResponse(q, ErrorNotImpl, "%s.", codeToMessgae(ErrorNotImpl));
}

bool CommandProc::cmdUnshare(QueueNode *q)
{
	return taskResponse(q, ErrorNotImpl, "%s.", codeToMessgae(ErrorNotImpl));
}


bool CommandProc::cmdShowShare(QueueNode *q)
{
	return taskResponse(q, ErrorNotImpl, "%s.", codeToMessgae(ErrorNotImpl));
}

class TBLsGroupShare: public TaskBuffer {
public:
	TBLsGroupShare() {
		mJsCommand	= NULL;
		mJsSID		= NULL;
		mJsSName	= NULL;
		mJsGID		= NULL;
		mJsGName	= NULL;
		mJsFrom		= NULL;
		mJsCount	= NULL;
		mGroup		= NULL;
		mShareList	= NULL;
		mShareInfo	= NULL;
		mListFrom	= 0;
		mListCount	= 0;
		mResourceCount	= 0;
		mResourceIndex	= 0;
		mShareIndex	= 0;
		mLoadCount	= 0;
	}
	virtual ~TBLsGroupShare() {
		if( mJsCommand )	delete mJsCommand;
		if( mGroup )		free(mGroup);
		if( mShareList )	free(mShareList);
		if( mShareInfo )	free(mShareInfo);
	}
	pjson::json *		mJsCommand;
	pjson::value *		mJsSID;
	pjson::value *		mJsSName;
	pjson::value *		mJsGID;
	pjson::value *		mJsGName;
	pjson::value *		mJsFrom;
	pjson::value *		mJsCount;
	QueryKeyType 		mSRef;
	QueryKeyType 		mGRef;
	ResultGroup *		mGroup;
	ResultList *		mShareList;
	ResultShare *		mShareInfo;
	size_t				mListFrom;
	size_t				mListCount;
	size_t				mResourceCount;
	size_t				mResourceIndex;
	size_t				mShareIndex;
	size_t				mLoadCount;
	pjson::builder		mJb;
};
bool CommandProc::cmdLsGroupShare(QueueNode *q)
{
	Task *task = q->getTask();
	int step = q->getStep();

	TBLsGroupShare *tb = (TBLsGroupShare *)task->getTaskBuffer();
	if( tb == NULL ) {
		tb = new TBLsGroupShare();
		if( tb == NULL ) {
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
		if( !task->setTaskBuffer(tb) ) {
			delete tb;
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
 	}

	switch(step) {
	case 0:
		{
			tb->mSRef.mId	= NULL;
			tb->mSRef.mName	= NULL;
			tb->mGRef.mId	= NULL;
			tb->mGRef.mName	= NULL;
			tb->mJsCommand	= q->detouchJSONMessage();
			pjson::value *vCmd = tb->mJsCommand->get("lsGroupShare");
			if( vCmd ) {
				tb->mJsSID		= tb->mJsCommand->get("sid", vCmd);
				tb->mJsSName	= tb->mJsCommand->get("serviceName", vCmd);
				tb->mJsGID		= tb->mJsCommand->get("gid", vCmd);
				tb->mJsGName	= tb->mJsCommand->get("groupName", vCmd);
				tb->mJsFrom		= tb->mJsCommand->get("from", vCmd);
				tb->mJsCount	= tb->mJsCommand->get("count", vCmd);
				if( tb->mJsSID && tb->mJsSID->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"sid\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsSName && tb->mJsSName->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"serviceName\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsGID && tb->mJsGID->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"rid\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsGName && tb->mJsGName->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"resourceName\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsFrom && tb->mJsFrom->vt != pjson::vt_int ) {
					return taskResponse(q, ErrorParameter, "%s. \"from\" type.", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsCount && tb->mJsCount->vt != pjson::vt_int ) {
					return taskResponse(q, ErrorParameter, "%s. \"count\" type.", codeToMessgae(ErrorParameter));
				}
				tb->mSRef.mId	= (char*)(tb->mJsSID   ? tb->mJsSID->vString : NULL);
				tb->mSRef.mName	= (char*)(tb->mJsSName ? tb->mJsSName->vString : NULL);
				tb->mGRef.mId	= (char*)(tb->mJsGID   ? tb->mJsGID->vString : NULL);
				tb->mGRef.mName	= (char*)(tb->mJsGName ? tb->mJsGName->vString : NULL);
			}

			if( tb->mGRef.mId == NULL ) {
				QnDBQuery *qn = new QnDBQuery(task);
				qn->queryGroup(&tb->mSRef, &tb->mGRef);
				return task->call(qn, step+1);
			}
		}

	case 1:
		{
			if( step == 1 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode code	= res->getResultCode();
				if( code != ErrorOk ) {
					return taskResponse(q, code, "Group info load error. %s", res->getMessagePtr());
				}
				tb->mGroup	= (ResultGroup*)res->mResult;
				res->mResult	= NULL;
				tb->mSRef.mId	= tb->mGroup->mGroup.serviceId;
				tb->mGRef.mId	= tb->mGroup->mGroup.id;
				tb->mGRef.mName	= tb->mGroup->mGroup.name;
			}
			step	= 1;
			QueryRangeType range;
			range.mStart	= tb->mJsFrom  ? tb->mJsFrom->vInt  : 0;
			range.mCount	= tb->mJsCount ? tb->mJsCount->vInt : -1;
			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryShareList(&tb->mSRef, &tb->mGRef, &range);
			return task->call(qn, step+1);
		}
		break;

	case 2:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "Share list load failed. %s", res->getMessagePtr());
			}

			tb->mShareList	= (ResultList*)res->mResult;
			res->mResult	= NULL;
			tb->mListFrom	= tb->mJsFrom  ? tb->mJsFrom->vInt : 0;
			tb->mListCount	= tb->mJsCount ? tb->mJsCount->vInt : 0;
			tb->mResourceCount	= tb->mShareList->mList.values;
			tb->mResourceIndex	= 0;
			if( !tb->mJb.init(512) ||
				!tb->mJb.beginObject() ||
				!tb->mJb.addObjectProp("result", 6) ||
				!tb->mJb.valueInt(0) ||
				!tb->mJb.addObjectProp("sequence", 8) ||
				!tb->mJb.valueInt(task->getSequence()) ||
				!tb->mJb.addObjectProp("gid", 3) ||
				!tb->mJb.valueString(tb->mGRef.mId) ||
				!tb->mJb.addObjectProp("from", 4) ||
				!tb->mJb.valueInt(tb->mListFrom) ) {
				taskLog(q, LOG_ERR, "json builder failed(1). code=%d.", tb->mJb.getError());
				return false;
			}
		}

	case 3:
		{
			if( step == 3 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode code	= res->getResultCode();
				if( code != ErrorOk ) {
					taskLog(q, LOG_WARNING, "Share info load error. code=%d gid=%s index=%d. %s",
							code, tb->mGRef.mId, tb->mResourceIndex, res->getMessage());
					if( code != ErrorNotFound ) {
						return taskResponse(q, code, "Share info load failed. $s", res->getMessagePtr());
					}
				} else {
					tb->mShareInfo  = (ResultShare*)res->mResult;
					res->mResult	= NULL;

					QueryKeyType rref;
					rref.mId	= tb->mShareInfo->mShare.resourceId;
					rref.mName	= NULL;
					QnDBQuery *qn = new QnDBQuery(task);
					qn->queryResource(NULL, &rref);
					return task->call(qn, step+1);
				}
			}
			step	= 3;
		}
	case 4:
		{
			if( step == 4 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode code	= res->getResultCode();
				if( code != ErrorOk ) {
					if( code != ErrorNotFound ) {
						return taskResponse(q, code, "Resource info load failed. %s", res->getMessagePtr());
					} else {
						taskLog(q, LOG_WARNING, "Resource info load error. %s", res->getMessage());
					}
				} else {
					ResultResource *resource = (ResultResource *)res->mResult;
					ResultShare *share = tb->mShareInfo;

					if( tb->mLoadCount == 0 ) {
						if( !tb->mJb.addObjectProp("shareInfo", 9) ||
							!tb->mJb.beginArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(2). code=%d.", tb->mJb.getError());
							return false;
						}
					}


					const char *dataMode="unknown";
					switch(share->mShare.dataMode) {
					case ShareDataFull:		dataMode	= "full";	break;
					case ShareDataIndex:	dataMode	= "index";	break;
					}

					StdBuffer accessMode;
					if( share->mShare.accessMode & ShareAccessWrite ) {
						accessMode.add("write", -1);
					}
					if( share->mShare.accessMode & ShareAccessGadget ) {
						if( !accessMode.empty() ) accessMode.add(",",-1);
						accessMode.add("write", -1);
					}
					if( share->mShare.accessMode & ShareAccessTag ) {
						if( !accessMode.empty() ) accessMode.add(",",-1);
						accessMode.add("tag", -1);
					}
					if( accessMode.empty() ) {
						accessMode.add("read", -1);
					}
					char _refTime[256];
					const char *refTime = "";
					if( resource->mResource.refTime != 0 ) {
						struct tm *tmp = gmtime(&resource->mResource.refTime);
						strftime(_refTime, sizeof(_refTime), "%Y/%m/%d-%H:%M:%S", tmp);
						refTime = _refTime;
					}
					StdBuffer keyShare;
					DBUtil::keyShare(share->mShare.resourceId, tb->mShareIndex, keyShare);

					if( !tb->mJb.addArrayContent() ||
						!tb->mJb.beginObject() ||
						!tb->mJb.addObjectProp("rid", 3) ||
						!tb->mJb.valueString(share->mShare.resourceId) ||
						!tb->mJb.addObjectProp("shareIndex", 10) ||
						!tb->mJb.valueInt(tb->mShareIndex) ||
						!tb->mJb.addObjectProp("shareId", 7) ||
						!tb->mJb.valueString(keyShare.getPtr()) ||
						!tb->mJb.addObjectProp("shareMode", 9) ||
						!tb->mJb.valueString(dataMode) ||
						!tb->mJb.addObjectProp("resourceName", 12) ||
						!tb->mJb.valueString(resource->mResource.name) ||
						!tb->mJb.addObjectProp("tag", 3) ||
						!tb->mJb.valueString(resource->mResource.tag ? resource->mResource.tag: "") ||
						!tb->mJb.addObjectProp("revision", 8) ||
						!tb->mJb.valueInt(resource->mResource.revision) ||
						!tb->mJb.addObjectProp("refTime", 7) ||
						!tb->mJb.valueString(refTime) ) {
						taskLog(q, LOG_ERR, "json builder failed(3). code=%d.", tb->mJb.getError());
						return false;
					}
					if( resource->mResource.gadgetCount > 0 ) {
						if( !tb->mJb.addObjectProp("gadgets", 7) ||
							!tb->mJb.beginArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(4). code=%d.", tb->mJb.getError());
							return false;
						}
						size_t i;
						for( i = 0; i < resource->mResource.gadgetCount; i++) {
							const char *refTime = "";
							if( resource->mResource.gadgetArray[i].refTime != 0) {
								char _refTime[256];
								strftime(_refTime, sizeof(_refTime), "%Y/%m/%d-%H:%M:%S", gmtime(&resource->mResource.gadgetArray[i].refTime));
								refTime = _refTime;
							}
							if( !tb->mJb.addArrayContent() ||
								!tb->mJb.beginObject() ||
								!tb->mJb.addObjectProp("id", 2) ||
								!tb->mJb.valueString(resource->mResource.gadgetArray[i].id ? resource->mResource.gadgetArray[i].id : "") ||
								!tb->mJb.addObjectProp("name", 4) ||
								!tb->mJb.valueString(resource->mResource.gadgetArray[i].name ? resource->mResource.gadgetArray[i].name : "") ||
								!tb->mJb.addObjectProp("tag", 3) ||
								!tb->mJb.valueString(resource->mResource.gadgetArray[i].tag ? resource->mResource.gadgetArray[i].tag : "") ||
								!tb->mJb.addObjectProp("refTime", 7) ||
								!tb->mJb.valueString(refTime) ||
								!tb->mJb.addObjectProp("revision", 8) ||
								!tb->mJb.valueInt(resource->mResource.gadgetArray[i].revision) ||
								!tb->mJb.endObject() ) {
								taskLog(q, LOG_ERR, "json builder failed(5). code=%d.", tb->mJb.getError());
								return false;
							}
						}
						if( !tb->mJb.endArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(6). code=%d.", tb->mJb.getError());
							return false;
						}
					}
					if( !tb->mJb.addObjectProp("parmission", 10) ||
						!tb->mJb.beginObject()) {
						taskLog(q, LOG_ERR, "json builder failed(7). code=%d.", tb->mJb.getError());
						return false;
					}
					if( !tb->mJb.addObjectProp("access", 6) ||
						!tb->mJb.valueString(accessMode.getPtr()) ) {
						taskLog(q, LOG_ERR, "json builder failed(8). code=%d.", tb->mJb.getError());
						return false;
					}
					if( share->mShare.endTime != 0 || share->mShare.fromTime != 0 ) {
						if( !tb->mJb.addObjectProp("time", 4) ||
							!tb->mJb.beginObject()) {
							taskLog(q, LOG_ERR, "json builder failed(9). code=%d.", tb->mJb.getError());
							return false;
						}
						if( share->mShare.fromTime != 0 ) {
							char _time[256];
							strftime(_time, sizeof(_time), "%Y/%m/%d-%H:%M:%S", gmtime(&share->mShare.fromTime));
							if( !tb->mJb.addObjectProp("from", 4) ||
								!tb->mJb.valueString(_time)) {
								taskLog(q, LOG_ERR, "json builder failed(10). code=%d.", tb->mJb.getError());
								return false;
							}
						}
						if( share->mShare.endTime != 0 ) {
							char _time[256];
							strftime(_time, sizeof(_time), "%Y/%m/%d-%H:%M:%S", gmtime(&share->mShare.endTime));
							if( !tb->mJb.addObjectProp("to", 2) ||
								!tb->mJb.valueString(_time)) {
								taskLog(q, LOG_ERR, "json builder failed(11). code=%d.", tb->mJb.getError());
								return false;
							}
						}
						if( !tb->mJb.endObject()) {
							taskLog(q, LOG_ERR, "json builder failed(12). code=%d.", tb->mJb.getError());
							return false;
						}
					}

					if( share->mShare.geoLocationCount > 0 ) {
						if( !tb->mJb.addObjectProp("geoLocation", 11) ||
							!tb->mJb.beginArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(13). code=%d.", tb->mJb.getError());
							return false;
						}
						size_t i;
						for( i = 0; i < share->mShare.geoLocationCount; i++) {
							if( !tb->mJb.addArrayContent() ||
								!tb->mJb.beginObject() ||
								!tb->mJb.addObjectProp("dis", 3) ||
								!tb->mJb.valueNumber(share->mShare.geoLocation[i].dis) ||
								!tb->mJb.addObjectProp("lat", 3) ||
								!tb->mJb.valueNumber(share->mShare.geoLocation[i].lat) ||
								!tb->mJb.addObjectProp("lon", 3) ||
								!tb->mJb.valueNumber(share->mShare.geoLocation[i].lon) ||
								!tb->mJb.endObject() ) {
								taskLog(q, LOG_ERR, "json builder failed(14). code=%d.", tb->mJb.getError());
								return false;
							}
						}
						if( !tb->mJb.endArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(15). code=%d.", tb->mJb.getError());
							return false;
						}
					}

					if( !tb->mJb.addObjectProp("gpsGrace", 8) ||
						!tb->mJb.valueInt(share->mShare.gpsGrace) ||
						!tb->mJb.addObjectProp("offlineGrace", 12) ||
						!tb->mJb.valueInt(share->mShare.offlineGrace)  ) {
						taskLog(q, LOG_ERR, "json builder failed(16). code=%d.", tb->mJb.getError());
						return false;
					}
					if( share->mShare.expireTime != 0 ) {
						char _time[256];
						strftime(_time, sizeof(_time), "%Y/%m/%d-%H:%M:%S", gmtime(&share->mShare.expireTime));
						if( !tb->mJb.addObjectProp("expire", 6) ||
						    !tb->mJb.valueString(_time)) {
							taskLog(q, LOG_ERR, "json builder failed(17). code=%d.", tb->mJb.getError());
							return false;
						}
					}

					char _createTime[256];
					strftime(_createTime, sizeof(_createTime), "%Y/%m/%d-%H:%M:%S", gmtime(&share->mShare.createTime));
					if( !tb->mJb.endObject() ||
						!tb->mJb.addObjectProp("createTime", 10) ||
						!tb->mJb.valueString(_createTime) ) {
						taskLog(q, LOG_ERR, "json builder failed(18). code=%d.", tb->mJb.getError());
						return false;
					}

					if( !tb->mJb.endObject() ) {
						taskLog(q, LOG_ERR, "json builder failed(19). code=%d.", tb->mJb.getError());
						return false;
					}
					tb->mLoadCount++;
				}
				tb->mResourceIndex++;
			}

			step = 4;

			if( tb->mResourceIndex < tb->mResourceCount /*&& (tb->mListCount == 0 || tb->mLoadCount < tb->mListCount)*/ ) {
				char * key = tb->mShareList->mList.value[tb->mResourceIndex];

				QueryKeyType mref;
				mref.mId	= key;
				mref.mName	= NULL;
				QnDBQuery *qn = new QnDBQuery(task);
				qn->queryShare(&tb->mSRef, &mref);
				return task->call(qn, step-1);
			}

			if( tb->mLoadCount != 0 ) {
				if( !tb->mJb.endArray() ) {
					taskLog(q, LOG_ERR, "json builder failed(20). code=%d.", tb->mJb.getError());
					return false;
				}
			}
			if( !tb->mJb.endObject() ) {
				taskLog(q, LOG_ERR, "json builder failed(21). code=%d.", tb->mJb.getError());
				return false;
			}
			return response(q,tb->mJb);
		}
		break;
	}
	taskLog(q, LOG_ERR, "unknown step=%d.", step);
	return false;
}

class TBLsResourceShare: public TaskBuffer {
public:
	TBLsResourceShare() {
		mJsCommand	= NULL;
		mJsSID		= NULL;
		mJsSName	= NULL;
		mJsRID		= NULL;
		mJsRName	= NULL;
		mJsFrom		= NULL;
		mJsCount	= NULL;
		mResource	= NULL;
		mListFrom	= 0;
		mListCount	= 0;
		mShareCount	= 0;
		mShareIndex	= 0;
		mLoadCount	= 0;
	}
	virtual ~TBLsResourceShare() {
		if( mJsCommand )	delete mJsCommand;
		if( mResource )		free(mResource);
	}
	pjson::json *		mJsCommand;
	pjson::value *		mJsSID;
	pjson::value *		mJsSName;
	pjson::value *		mJsRID;
	pjson::value *		mJsRName;
	pjson::value *		mJsFrom;
	pjson::value *		mJsCount;
	QueryKeyType 		mSRef;
	QueryKeyType 		mRRef;
	ResultResource *	mResource;
	size_t				mListFrom;
	size_t				mListCount;
	size_t				mShareCount;
	size_t				mShareIndex;
	size_t				mLoadCount;
	pjson::builder		mJb;
};

bool CommandProc::cmdLsResourceShare(QueueNode *q)
{
	Task *task = q->getTask();
	int step = q->getStep();

	TBLsResourceShare *tb = (TBLsResourceShare *)task->getTaskBuffer();
	if( tb == NULL ) {
		tb = new TBLsResourceShare();
		if( tb == NULL ) {
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
		if( !task->setTaskBuffer(tb) ) {
			delete tb;
			taskLog(q, LOG_ERR, "%s.", codeToMessgae(ErrorNoMemory));
			return false;
		}
 	}

	switch(step) {
	case 0:
		{
			tb->mSRef.mId	= NULL;
			tb->mSRef.mName	= NULL;
			tb->mRRef.mId	= NULL;
			tb->mRRef.mName	= NULL;
			tb->mJsCommand	= q->detouchJSONMessage();
			pjson::value *vCmd = tb->mJsCommand->get("lsResourceShare");
			if( vCmd ) {
				tb->mJsSID		= tb->mJsCommand->get("sid", vCmd);
				tb->mJsSName	= tb->mJsCommand->get("serviceName", vCmd);
				tb->mJsRID		= tb->mJsCommand->get("rid", vCmd);
				tb->mJsRName	= tb->mJsCommand->get("resourceName", vCmd);
				tb->mJsFrom		= tb->mJsCommand->get("from", vCmd);
				tb->mJsCount	= tb->mJsCommand->get("count", vCmd);
				if( tb->mJsSID && tb->mJsSID->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"sid\" type", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsRName && tb->mJsRName->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"serviceName\" type", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsRID && tb->mJsRID->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"rid\" type", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsRName && tb->mJsRName->vt != pjson::vt_string ) {
					return taskResponse(q, ErrorParameter, "%s. \"resourceName\" type", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsFrom && tb->mJsFrom->vt != pjson::vt_int ) {
					return taskResponse(q, ErrorParameter, "%s. \"from\" type", codeToMessgae(ErrorParameter));
				}
				if( tb->mJsCount && tb->mJsCount->vt != pjson::vt_int ) {
					return taskResponse(q, ErrorParameter, "%s. \"count\" type", codeToMessgae(ErrorParameter));
				}
				tb->mSRef.mId	= (char*)(tb->mJsSID   ? tb->mJsSID->vString : NULL);
				tb->mSRef.mName	= (char*)(tb->mJsSName ? tb->mJsSName->vString : NULL);
				tb->mRRef.mId	= (char*)(tb->mJsRID   ? tb->mJsRID->vString : NULL);
				tb->mRRef.mName	= (char*)(tb->mJsRName ? tb->mJsRName->vString : NULL);
			}

			QnDBQuery *qn = new QnDBQuery(task);
			qn->queryResource(&tb->mSRef, &tb->mRRef);
			return task->call(qn, step+1);
		}
		break;

	case 1:
		{
			QnDBResult *res	= (QnDBResult*)q;
			ErrorCode code	= res->getResultCode();
			if( code != ErrorOk ) {
				return taskResponse(q, code, "Resource load failed. %s", res->getMessagePtr());
			}

			tb->mResource	= (ResultResource*)res->mResult;
			res->mResult	= NULL;
			tb->mListFrom	= tb->mJsFrom  ? tb->mJsFrom->vInt : 0;
			tb->mListCount	= tb->mJsCount ? tb->mJsCount->vInt : 0;
			tb->mShareCount	= tb->mResource->mResource.shareCount;
			tb->mShareIndex	= 0;
			if( !tb->mJb.init(512) ||
				!tb->mJb.beginObject() ||
				!tb->mJb.addObjectProp("result", 6) ||
				!tb->mJb.valueInt(0) ||
				!tb->mJb.addObjectProp("sequence", 8) ||
				!tb->mJb.valueInt(task->getSequence()) ||
				!tb->mJb.addObjectProp("rid", 3) ||
				!tb->mJb.valueString(tb->mResource->mResource.id) ||
				!tb->mJb.addObjectProp("from", 4) ||
				!tb->mJb.valueInt(tb->mListFrom) ) {
				taskLog(q, LOG_ERR, "json builder failed(1). code=%d", tb->mJb.getError());
				return false;
			}
			taskLog(q, LOG_DEBUG, "%s::lsResourceShare: share=%d from=%d count=%d",
					getName(), tb->mShareCount, tb->mListFrom, tb->mListCount );

		}
	case 2:
		{
			if( step == 2 ) {
				QnDBResult *res	= (QnDBResult*)q;
				ErrorCode code	= res->getResultCode();
				if( code != ErrorOk ) {
					if( code != ErrorNotFound ) {
						return taskResponse(q, code, "Share info load failed. %s", res->getMessagePtr());
					} else {
						taskLog(q, LOG_WARNING, "Share info load failed. %s", res->getMessage());
					}
				} else {
					if( tb->mLoadCount == 0 ) {
						if( !tb->mJb.addObjectProp("shareInfo", 9) ||
							!tb->mJb.beginArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(2). code=%d", tb->mJb.getError());
							return false;
						}
					}

					ResultShare *share = (ResultShare*)res->mResult;

					const char *dataMode="unknown";
					switch(share->mShare.dataMode) {
					case ShareDataFull:		dataMode	= "full";	break;
					case ShareDataIndex:	dataMode	= "index";	break;
					}
					StdBuffer accessMode;
					if( share->mShare.accessMode & ShareAccessWrite ) {
						accessMode.add("write", -1);
					}
					if( share->mShare.accessMode & ShareAccessGadget ) {
						if( !accessMode.empty() ) accessMode.add(",",-1);
						accessMode.add("write", -1);
					}
					if( share->mShare.accessMode & ShareAccessTag ) {
						if( !accessMode.empty() ) accessMode.add(",",-1);
						accessMode.add("tag", -1);
					}
					if( accessMode.empty() ) {
						accessMode.add("read", -1);
					}
					if( !tb->mJb.addArrayContent() ||
						!tb->mJb.beginObject() ||
						!tb->mJb.addObjectProp("shareMode", 9) ||
						!tb->mJb.valueString(dataMode) ) {
						taskLog(q, LOG_ERR, "json builder failed(3). code=%d", tb->mJb.getError());
						return false;
					}
					if( share->mShare.groupCount > 0 ) {
						if( !tb->mJb.addObjectProp("groups", 6) ||
							!tb->mJb.beginArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(4). code=%d", tb->mJb.getError());
							return false;
						}
						size_t i;
						for( i = 0; i < share->mShare.groupCount; i++ ) {
							if( !tb->mJb.addArrayContent() ||
								!tb->mJb.valueString(share->mShare.groupArray[i].mId) ) {
								taskLog(q, LOG_ERR, "json builder failed(5). code=%d", tb->mJb.getError());
								return false;
							}
						}
						if( !tb->mJb.endArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(6). code=%d", tb->mJb.getError());
							return false;
						}
					}
					if( !tb->mJb.addObjectProp("parmission", 10) ||
						!tb->mJb.beginObject()) {
						taskLog(q, LOG_ERR, "json builder failed(7). code=%d", tb->mJb.getError());
						return false;
					}
					if( !tb->mJb.addObjectProp("access", 6) ||
						!tb->mJb.valueString(accessMode.getPtr()) ) {
						taskLog(q, LOG_ERR, "json builder failed(8). code=%d", tb->mJb.getError());
						return false;
					}
					if( share->mShare.endTime != 0 || share->mShare.fromTime != 0 ) {
						if( !tb->mJb.addObjectProp("time", 4) ||
							!tb->mJb.beginObject()) {
							taskLog(q, LOG_ERR, "json builder failed(9). code=%d", tb->mJb.getError());
							return false;
						}
						if( share->mShare.fromTime != 0 ) {
							char _time[256];
							strftime(_time, sizeof(_time), "%Y/%m/%d-%H:%M:%S", gmtime(&share->mShare.fromTime));
							if( !tb->mJb.addObjectProp("from", 4) ||
								!tb->mJb.valueString(_time)) {
								taskLog(q, LOG_ERR, "json builder failed(10). code=%d", tb->mJb.getError());
								return false;
							}
						}
						if( share->mShare.endTime != 0 ) {
							char _time[256];
							strftime(_time, sizeof(_time), "%Y/%m/%d-%H:%M:%S", gmtime(&share->mShare.endTime));
							if( !tb->mJb.addObjectProp("to", 2) ||
								!tb->mJb.valueString(_time)) {
								taskLog(q, LOG_ERR, "json builder failed(11). code=%d", tb->mJb.getError());
								return false;
							}
						}
						if( !tb->mJb.endObject()) {
							taskLog(q, LOG_ERR, "json builder failed(12). code=%d", tb->mJb.getError());
							return false;
						}
					}

					if( share->mShare.geoLocationCount > 0 ) {
						if( !tb->mJb.addObjectProp("geoLocation", 11) ||
							!tb->mJb.beginArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(13). code=%d", tb->mJb.getError());
							return false;
						}
						size_t i;
						for( i = 0; i < share->mShare.geoLocationCount; i++) {
							if( !tb->mJb.addArrayContent() ||
								!tb->mJb.beginObject() ||
								!tb->mJb.addObjectProp("dis", 3) ||
								!tb->mJb.valueNumber(share->mShare.geoLocation[i].dis) ||
								!tb->mJb.addObjectProp("lat", 3) ||
								!tb->mJb.valueNumber(share->mShare.geoLocation[i].lat) ||
								!tb->mJb.addObjectProp("lon", 3) ||
								!tb->mJb.valueNumber(share->mShare.geoLocation[i].lon) ||
								!tb->mJb.endObject() ) {
								taskLog(q, LOG_ERR, "json builder failed(14). code=%d", tb->mJb.getError());
								return false;
							}
						}
						if( !tb->mJb.endArray() ) {
							taskLog(q, LOG_ERR, "json builder failed(15). code=%d", tb->mJb.getError());
							return false;
						}
					}

					if( !tb->mJb.addObjectProp("gpsGrace", 8) ||
						!tb->mJb.valueInt(share->mShare.gpsGrace) ||
						!tb->mJb.addObjectProp("offlineGrace", 12) ||
						!tb->mJb.valueInt(share->mShare.offlineGrace)  ) {
						taskLog(q, LOG_ERR, "json builder failed(16). code=%d", tb->mJb.getError());
						return false;
					}
					if( share->mShare.expireTime != 0 ) {
						char _time[256];
						strftime(_time, sizeof(_time), "%Y/%m/%d-%H:%M:%S", gmtime(&share->mShare.expireTime));
						if( !tb->mJb.addObjectProp("expire", 6) ||
						    !tb->mJb.valueString(_time)) {
							taskLog(q, LOG_ERR, "json builder failed(17). code=%d", tb->mJb.getError());
							return false;
						}
					}

					char _createTime[256];
					strftime(_createTime, sizeof(_createTime), "%Y/%m/%d-%H:%M:%S", gmtime(&share->mShare.createTime));
					if( !tb->mJb.endObject() ||
						!tb->mJb.addObjectProp("createTime", 10) ||
						!tb->mJb.valueString(_createTime) ) {
						taskLog(q, LOG_ERR, "json builder failed(18). code=%d", tb->mJb.getError());
						return false;
					}

					if( !tb->mJb.endObject() ) {
						taskLog(q, LOG_ERR, "json builder failed(19). code=%d", tb->mJb.getError());
						return false;
					}
					tb->mLoadCount++;
				}
				tb->mShareIndex++;
			}

			step = 2;

			if( tb->mShareIndex < tb->mShareCount && (tb->mListCount == 0 || tb->mLoadCount < tb->mListCount) ) {
				QnDBQuery *qn = new QnDBQuery(task);
				StdBuffer keyShare;
				DBUtil::keyShare(tb->mResource->mResource.id, tb->mShareIndex, keyShare);
				QueryKeyType mref;
				mref.mId	= keyShare.getPtr();
				mref.mName	= NULL;
				qn->queryShare(&tb->mSRef, &mref);
				return task->call(qn, step);
			}

			if( tb->mLoadCount != 0 ) {
				if( !tb->mJb.endArray() ) {
					taskLog(q, LOG_ERR, "json builder failed(20). code=%d", tb->mJb.getError());
					return false;
				}
			}
			if( !tb->mJb.endObject() ) {
				taskLog(q, LOG_ERR, "json builder failed(21). code=%d", tb->mJb.getError());
				return false;
			}
			return response(q,tb->mJb);
		}
		break;
	}
	taskLog(q, LOG_ERR, "unknown step=%d.", step);
	return false;
}

bool CommandProc::cmdLsDeviceShare(QueueNode *q)
{
	return taskResponse(q, ErrorNotImpl, "%s", codeToMessgae(ErrorNotImpl));
}


}

