/*
 * This file is part of the µOS++ distribution.
 *   (https://github.com/micro-os-plus)
 * Copyright (c) 2014 Liviu Ionescu.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

// ----------------------------------------------------------------------------

#include "cortexm/exception-handlers.h"

// ----------------------------------------------------------------------------

void __attribute__((weak))
Default_Handler(void);

// Forward declaration of the specific IRQ handlers. These are aliased
// to the Default_Handler, which is a 'forever' loop. When the application
// defines a handler (with the same name), this will automatically take
// precedence over these weak definitions

void __attribute__ ((weak, alias ("Default_Handler")))
POWER_CLOCK_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
RADIO_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
UARTE0_UART0_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
NFCT_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
GPIOTE_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SAADC_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
TIMER0_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
TIMER1_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
TIMER2_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
RTC0_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
TEMP_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
RNG_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
ECB_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
CCM_AAR_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
WDT_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
RTC1_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
QDEC_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
COMP_LPCOMP_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SWI0_EGU0_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SWI1_EGU1_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SWI2_EGU2_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SWI3_EGU3_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SWI4_EGU4_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SWI5_EGU5_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
TIMER3_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
TIMER4_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
PWM0_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
PDM_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
MWU_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
PWM1_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
PWM2_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SPIM2_SPIS2_SPI2_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
RTC2_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
I2S_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
FPU_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
USBD_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
UARTE1_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
PWM3_IRQHandler(void);

void __attribute__ ((weak, alias ("Default_Handler")))
SPIM3_IRQHandler(void);

// ----------------------------------------------------------------------------

extern unsigned int _estack;

typedef void
(* const pHandler)(void);

// ----------------------------------------------------------------------------

// The vector table.
// This relies on the linker script to place at correct location in memory.

__attribute__ ((section(".isr_vector"),used))
pHandler __isr_vectors[] =
  { //
    (pHandler) &_estack,                          // The initial stack pointer
        Reset_Handler,                            // The reset handler

        NMI_Handler,                              // The NMI handler
        HardFault_Handler,                        // The hard fault handler

#if defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__)
        MemManage_Handler,                        // The MPU fault handler
        BusFault_Handler,                         // The bus fault handler
        UsageFault_Handler,                       // The usage fault handler
#else
        0, 0, 0,                                  // Reserved
#endif
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        SVC_Handler,                              // SVCall handler
#if defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__)
        DebugMon_Handler,                         // Debug monitor handler
#else
        0,                    // Reserved
#endif
        0,                                        // Reserved
        PendSV_Handler,                           // The PendSV handler
        SysTick_Handler,                          // The SysTick handler

        // ----------------------------------------------------------------------
        // nRF52833 vectors
        POWER_CLOCK_IRQHandler,
        RADIO_IRQHandler,
        UARTE0_UART0_IRQHandler,
        SPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0_IRQHandler,
        SPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1_IRQHandler,
        NFCT_IRQHandler,
        GPIOTE_IRQHandler,
        SAADC_IRQHandler,
        TIMER0_IRQHandler,
        TIMER1_IRQHandler,
        TIMER2_IRQHandler,
        RTC0_IRQHandler,
        TEMP_IRQHandler,
        RNG_IRQHandler,
        ECB_IRQHandler,
        CCM_AAR_IRQHandler,
        WDT_IRQHandler,
        RTC1_IRQHandler,
        QDEC_IRQHandler,
        COMP_LPCOMP_IRQHandler,
        SWI0_EGU0_IRQHandler,
        SWI1_EGU1_IRQHandler,
        SWI2_EGU2_IRQHandler,
        SWI3_EGU3_IRQHandler,
        SWI4_EGU4_IRQHandler,
        SWI5_EGU5_IRQHandler,
        TIMER3_IRQHandler,
        TIMER4_IRQHandler,
        PWM0_IRQHandler,
        PDM_IRQHandler,
        0,                                        // Reserved
        0,                                        // Reserved
        MWU_IRQHandler,
        PWM1_IRQHandler,
        PWM2_IRQHandler,
        SPIM2_SPIS2_SPI2_IRQHandler,
        RTC2_IRQHandler,
        I2S_IRQHandler,
        FPU_IRQHandler,
        USBD_IRQHandler,
        UARTE1_IRQHandler,
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        PWM3_IRQHandler,
        0,                                        // Reserved
        SPIM3_IRQHandler,
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
        0,                                        // Reserved
    };

// ----------------------------------------------------------------------------

// Processor ends up here if an unexpected interrupt occurs or a specific
// handler is not present in the application code.

void __attribute__ ((section(".after_vectors")))
Default_Handler(void)
{
  while (1)
    {
      ;
    }
}

// ----------------------------------------------------------------------------
