//! @file		pf_patrol.h
//! @brief		プラットフォーム(ラインセンサ)ヘッダファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_PATROL_H
#define PF_PATROL_H

#include "pf_types.h"

//! @brief		ラインセンサのID
typedef enum PF_PATROL_ID_Tag
{
	PF_PATROL_ID_L,							//!< 左センサ
	PF_PATROL_ID_R,							//!< 右センサ
	PF_PATROL_ID_MAX,						//!< (IDの個数を表す)
} PF_PATROL_ID;

//! @brief		ラインセンサで検出できる色
typedef enum PF_PATROL_COLOR_Tag
{
	PF_PATROL_COLOR_WHITE = 0,				//!< 白色
	PF_PATROL_COLOR_BLACK,					//!< 黒色
	PF_PATROL_COLOR_MAX,					//!< (色の個数を表す)
} PF_PATROL_COLOR;

//! @brief		ラインセンサ初期化
//! @remarks	プラットフォーム初期化処理から呼び出すこと
void pf_patrol_init(void);

//! @brief		ラインセンサ定期タスク
//! @remarks	プラットフォーム定期タスク(入力系)処理から呼び出すこと
void pf_patrol_task(void);

//! @brief		ラインセンサの白黒状態を取得
//! @param		[in] id			ラインセンサのID
//! @return		色状態(PF_PATROL_COLOR_WHITE=白色/PF_PATROL_COLOR_BLACK=黒色)
PF_PATROL_COLOR pf_patrol_line(PF_PATROL_ID id);

#endif  // PF_PATROL_H
