//! @file		pf_led.h
//! @brief		プラットフォーム(LED)ヘッダファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_LED_H
#define PF_LED_H

#include "pf_types.h"

//! @brief		LEDのID
typedef enum PF_LED_ID_Tag
{
	PF_LED_ID_L,							//!< 左側LED
	PF_LED_ID_R,							//!< 右側LED
	PF_LED_ID_MAX,							//!< (IDの個数を表す)
} PF_LED_ID;

//! @brief		LED初期化
//! @remarks	プラットフォーム初期化処理から呼び出すこと
void pf_led_init(void);

//! @brief		LED定期タスク
//! @remarks	プラットフォーム定期タスク(出力系)処理から呼び出すこと
void pf_led_task(void);

//! @brief		LED制御
//! @param		[in] id			LEDのID
//! @param		[in] ctrl		LED制御情報(TRUE=LED点灯/FALSE=LED消灯)
void pf_led_ctrl(PF_LED_ID id, BOOL ctrl);

#endif  // PF_LED_H
