//! @file		pf_interrupt.h
//! @brief		プラットフォーム(割り込み)ヘッダファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_INTERRUPT_H
#define PF_INTERRUPT_H

#include "pf_types.h"

//! @brief		割り込み優先度(最大8レベル。レベル0が最も高く、レベル7が最も低い)
typedef enum PF_INTERRUPT_PRI_Tag
{
	PF_INTERRUPT_PRI_SYSTICK = 0,			//!< SysTick
	PF_INTERRUPT_PRI_UART,					//!< UART
	PF_INTERRUPT_PRI_DISPLAY_TIMER,			//!< Display Timer
	PF_INTERRUPT_PRI_I2C_INT,				//!< I2C(内部)
	PF_INTERRUPT_PRI_I2C_EXT,				//!< I2C(外部)
	PF_INTERRUPT_PRI_MUSIC,					//!< 音楽演奏
} PF_INTERRUPT_PRI;

//! @brief		グローバル割り込み禁止
//! @return		直前のグローバル割り込み禁止状態(1:割り込み禁止/0:割り込み許可)
u4 pf_interrupt_global_disable(void);

//! @brief		グローバル割り込み復元
//! @param		[in] primask	pf_interrupt_global_disable()の返り値
void pf_interrupt_global_restore(u4 primask);

//! @brief		ローカル割り込み禁止
//! @param		[in] pri		割り込み優先度
//! @return		直前のローカル割り込み禁止状態(1:割り込み禁止/0:割り込み許可)
u4 pf_interrupt_local_disable(PF_INTERRUPT_PRI pri);

//! @brief		ローカル割り込み復元
//! @param		[in] pri		割り込み優先度
//! @param		[in] enable		pf_interrupt_local_disable(pri)の返り値
void pf_interrupt_local_restore(PF_INTERRUPT_PRI pri, u4 enable);

#endif  // PF_INTERRUPT_H
