// This module is used for getting all the advertisements from the database, that
// the user has created. The function takes a username-string and a fragments-string
// as parameters. It then performs a graphql-query with node-fetch-module. The query
// returns the advertisements as a json-object with the fields specified in the
// fragments-parameter. The result is then put inside another object's "docs"-fields
// to make it compatible with the template.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "haeKayttajanIlmoitukset": async (username, frags, cb) => {

        const data = JSON.stringify({
            query: `{
                ilmoituksetKayttajan(Kayttajatunnus: "${username}") {
                    ${frags}
                }
            }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );

        const json = await vastaus.json();
        let ilmoitusarray = [{ docs: json.data.ilmoituksetKayttajan }];
        cb(ilmoitusarray);

    }

};