// This module is used for getting all of the advertisements from the database.
// The function needs no parameters. It simply performs a graphql-query with
// node-fetch-module and returns the advertisements as a json-object.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "haeKaikki": async (cb) => {

        const data = JSON.stringify({
            query: `{
                       Ilmoitukset {
                            IlmoitusId
                            title
                            desc
                            auth
                            date
                            ala
                        }
                    }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );

        const json = await vastaus.json();
        cb(json.data.Ilmoitukset);
		
    }

};