// This module is used for getting a specific advertisement from the database.
// The function takes an advertisement id-integer and a fragments-string as
// parameters. It then performs a graphql-query with node-fetch-module and
// returns an advertisement with the fields specified in the fragments parameter.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "haeIlmoitus": async (tunnus, frags, cb) => {

        const data = JSON.stringify({
            query: `{
						Ilmoitus(IlmoitusId: ${tunnus}) {
                            ${frags}
					}
			}`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );

        const json = await vastaus.json();
        cb(json.data.Ilmoitus);
		
    }

};