// This module is used for creating a new user document to the database. The function
// takes a request body-object as it's only parameter. It first checks whether all the
// fields in the registration form have been filled properly. If not, a notification
// message is returned in callback. If the form is filled properly, the function creates
// a hash from the password the user has submitted with bcrypt and creates a new datetime
// for the user profile before performing the graphql-mutation function with
// node-fetch-module. After performing the graphql-mutation the function generates a
// json web token with the username that was submitted. It then opens an html page that
// will automatially clear the browser's localStorage, set an access_token in it with
// the value of the generated json web token and redirect to front page.

const fetch = require('node-fetch');
const bcrypt = require('bcrypt');
var jwt = require('jsonwebtoken');
const { secret, url } = require('../main');

module.exports = {

    "luoTunnus": async (requestbody, cb) => {

        if (requestbody.etunimi == "" ||
            requestbody.sukunimi == "" ||
            requestbody.sukupuoli == undefined ||
            requestbody.rooli == undefined ||
            requestbody.kotiosoite == "" ||
            requestbody.puhelinnumero == "") {

            let message = "<p style='color: red; text-shadow: 0px 0px 0px red;'>Täytä jokainen kenttä!</p>";
            cb(message);

        } else {

            const date = new Date();
            const datestring = date.toString();
            const tiiviste = await bcrypt.hash(requestbody.psswrd, 10);
            const data = JSON.stringify({
                query: `mutation {
                        tunnuksenLuonti(aika: "${datestring}",
                                        Kayttajatunnus: "${requestbody.username}",
                                        Salasana: "${tiiviste}",
                                        Etunimi: "${requestbody.etunimi}",
                                        Sukunimi: "${requestbody.sukunimi}",
                                        Sukupuoli: ${requestbody.sukupuoli},
                                        rooli: ${requestbody.rooli},
                                        Email: "${requestbody.email}",
                                        Homeaddress: "${requestbody.kotiosoite}",
                                        Phonenumber: "${requestbody.puhelinnumero}"
                                    ) {
                            KayttajaTunnus
                            }
                        }`,
                variables: null
            });
            const vastaus = await fetch(
                url,
                {
                    method: 'post',
                    body: data,
                    headers: {
                        'Content-Type': 'application/json'
                    },
                }
            );

            const json = await vastaus.json();
            const token = jwt.sign({ username: json.data.tunnuksenLuonti.KayttajaTunnus }, secret);
            let silta = `
            <!DOCTYPE html>
                <html>
                    <head>
                        <meta charset="UTF-8">
                        <script>
                            window.onload = () => {
                                setTimeout(() => {
                                    document.getElementById('send').click();
                                }, 1000);
                            };
                            localStorage.clear();
                            localStorage.setItem('access_token', '${token}');
                        </script>
                    </head>
                    <body>
                        <h4>Odota hetki.</h4>
                        <form method="POST" action="/home">
                            <input type="hidden" name="access" value='${token}'>
                            <button style='visibility: hidden' id = "send">Siirry etusivulle.</button>
                        </form>
                    <body>
                </html>
            `;

            cb(null, silta);
            
        }

    }



};