// This module is used for updating a user document in the database by adding an application
// id to a document's "Documents"-field. The function takes a username-string and an application
// id-integer as parameters. Then a graphql-mutation is performed with node-fetch-module.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "tallennaHakemus": async (ktunnus, hakid, cb) => {
        const data = JSON.stringify({
            query: `mutation {
                        hakemusidTallennus(kayttajatunnus: "${ktunnus}", hakemusid: ${hakid})
                    }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        console.log(json.data.hakemusidTallennus);
        cb();
    }

};