// This module is used in deleting an application document from the database.
// The function takes an application id-integer as parameter. Then a
// graphql-mutation is performed with node-fetch-module.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "poistaHakemus": async (tunnus, cb) => {
        const data = JSON.stringify({
            query: `mutation {
						hakemuksenPoisto(id: ${tunnus}) 
					  }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        console.log(json.data.hakemuksenPoisto);
        cb();
    }

};