// This module is used for adding a cv-document to the database with GridFSBucket.
// The function takes a request files-object and a username-string as parameters.
// A temporary file path is first created to which the cv-document from the request
// file-object is copied. A read stream is then created from which the file is then
// uploaded to the fs.files collection in the database with the username and filename.
// When the upload is finished, the temporary file path is unlinked (deleted).
// The user document is then updated separately with a grahpql mutation. The "cvfile" field
// is updated with the filename or if the field doesn't exist, then it gets created.

const fetch = require('node-fetch');
const fs = require('fs');
var path = require('path');
const mongodb = require('mongodb');
const { dburl, url } = require('../main');

module.exports = {

    "lisaaCV": async (rqstfiles, username, cb) => {

        let filepath = await path.join(__dirname, '../', rqstfiles.cv.name);
        await rqstfiles.cv.mv(filepath);
        await mongodb.MongoClient.connect(dburl,
            { useNewUrlParser: true, useUnifiedTopology: true }, (error, client) => {
            let db = client.db('ont_database');
            let bucket = new mongodb.GridFSBucket(db);
            fs.createReadStream(filepath).pipe(bucket.openUploadStreamWithId(username, rqstfiles.cv.name)).on('finish', () => {
                fs.unlinkSync(filepath);
            });
        });

        const data = JSON.stringify({
            query: `mutation {
                cvnLisays(Kayttajatunnus: "${username}", cvfile: "${rqstfiles.cv.name}")
            }`,
            variables: null
        });

        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );

        const json = await vastaus.json();
        console.log(json.data.cvnLisays);
        cb();

    }
    
};